/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class Thumbnail
extends JPanel {
    private Image image;
    private ThumbnailListener listener;

    public void setThumbnailSize(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
    }

    public void setListener(ThumbnailListener tl) {
        this.listener = tl;
    }

    public void fireSelected() {
        if (this.listener != null) {
            this.listener.selected(this);
        }
    }

    public void setThumbnail(Image img) {
        this.image = img;
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.image != null) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.image, 1, 1, this.getWidth() - 2, this.getHeight() - 2, null);
        }
    }
}

