/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.Axis;
import Plot.PlotData;
import java.awt.Color;
import java.util.Vector;

public class PlotSeries
extends Vector
implements Cloneable {
    public static final int LINE = 1;
    public static final int SQUARE = 0;
    public static final int BAR = 3;
    public static final int Y_LABELS_LEFT = 0;
    public static final int Y_LABELS_RIGHT = 1;
    public static final int Y_LABELS_BOTH = 2;
    public Color color;
    public int type;
    public int yLabelSide;
    public Axis xAxis;
    private int m_factor = 1;
    private boolean m_doFactor = true;
    private PlotData m_highlighted = null;

    public PlotSeries() {
        this(Color.BLUE);
    }

    public PlotSeries(int type) {
        this();
    }

    public PlotSeries(Color c) {
        this.color = c;
    }

    public PlotSeries(Color c, int type) {
        this(c);
        this.type = type;
    }

    public PlotSeries(Color c, int type, int yLabelSide) {
        this(c, type);
        this.yLabelSide = yLabelSide;
    }

    public void doFactor(boolean doFactor) {
        this.m_doFactor = doFactor;
    }

    public int getFactor() {
        if (this.m_factor == -1) {
            int factor = 1;
            if (this.m_doFactor) {
                double max = this.getMax();
                while (max / (double)factor >= 10.0) {
                    factor *= 10;
                }
            }
            if (factor > this.m_factor) {
                this.m_factor = factor;
            }
        }
        return this.m_factor;
    }

    public synchronized void addElement(Object obj) {
        int i;
        for (i = super.size() - 1; i >= 0 && ((PlotData)obj).time < ((PlotData)super.elementAt((int)i)).time; --i) {
        }
        super.add(++i, obj);
        ((PlotData)obj).owner = this;
        this.m_factor = -1;
    }

    public void setHighlighted(PlotData pd) {
        this.m_highlighted = pd;
    }

    public PlotData getHighlighted() {
        return this.m_highlighted;
    }

    public double getMax() {
        return this.getMax(0.0, Double.MAX_VALUE);
    }

    public double getMax(double startTime) {
        return this.getMax(startTime, Double.MAX_VALUE);
    }

    public double getMax(double startTime, double endTime) {
        double max = Double.MIN_VALUE;
        if (this.size() == 0) {
            return 0.0;
        }
        PlotData pd = (PlotData)this.elementAt(0);
        for (int i = 0; i < this.size(); ++i) {
            pd = (PlotData)this.elementAt(i);
            if (pd.time < startTime || pd.time > endTime || !(pd.getDouble() > max)) continue;
            max = pd.getDouble();
        }
        return max;
    }

    public double getMin() {
        return this.getMin(0.0, Double.MAX_VALUE);
    }

    public double getMin(double startTime) {
        return this.getMin(startTime, Double.MAX_VALUE);
    }

    public double getMin(double startTime, double endTime) {
        double min = Double.MAX_VALUE;
        if (this.size() == 0) {
            return 0.0;
        }
        PlotData pd = (PlotData)this.elementAt(0);
        for (int i = 0; i < this.size(); ++i) {
            pd = (PlotData)this.elementAt(i);
            if (pd.time < startTime || pd.time > endTime || !(pd.getDouble() < min)) continue;
            min = pd.getDouble();
        }
        return min;
    }

    public Object clone() {
        PlotSeries retValue = (PlotSeries)super.clone();
        retValue.color = this.color;
        retValue.type = this.type;
        retValue.yLabelSide = this.yLabelSide;
        retValue.xAxis = this.xAxis;
        retValue.m_factor = this.m_factor;
        return retValue;
    }

    void clearHighlighted() {
        this.m_highlighted = null;
    }
}

