/*
 * Decompiled with CFR 0.152.
 */
import JniorProtocol.Devices.Device;
import JniorProtocol.Devices.Externals.ExternalTypeFE;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Boolean2;
import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Helpers.Dialogs.LoginDialog;
import JniorProtocol.Helpers.Effects.BlurPane;
import JniorProtocol.Helpers.Effects.DetailView;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.ConnectionListener;
import JniorProtocol.Listeners.EnumerationListener;
import JniorProtocol.Listeners.LoginListener;
import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.Properties.ConnectionProperties;
import JniorProtocol.Properties.LoginProperties;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import Plot.Axis;
import Plot.Graph;
import Plot.PlotData;
import Plot.PlotSeries;
import Plot.ViewData;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UsageMeterMain
extends jrCommPanel
implements Pageable,
ActionListener,
ThumbnailListener,
RegistryListener,
EnumerationListener {
    public static final String APP_NAME = "Utility Usage Monitor";
    private static final String VERSION = AssemblyInfo.getVersion();
    private static final int CHARTS = 5;
    public static final int INPUTS = 8;
    public UsageMeterApplet scriptManager = null;
    private static String graphTitle = "";
    private static final Color[] RUN_CHART_COLOR = new Color[]{new Color(84, 104, 144), new Color(0, 51, 153), new Color(0, 51, 102)};
    private PlotSeries psInstantaneous = new PlotSeries(RUN_CHART_COLOR[1], 1);
    private PlotSeries xHourLabels = new PlotSeries(Color.BLACK);
    private PlotSeries runHours = new PlotSeries(RUN_CHART_COLOR[0], 3);
    private PlotSeries xDayLabels = new PlotSeries(Color.BLACK);
    private PlotSeries runDays = new PlotSeries(RUN_CHART_COLOR[0], 3);
    private PlotSeries xWeekLabels = new PlotSeries(Color.BLACK);
    private PlotSeries runWeeks = new PlotSeries(RUN_CHART_COLOR[0], 3);
    private PlotSeries xWeeksOfYearLabels = new PlotSeries(Color.BLACK);
    private PlotSeries runYear = new PlotSeries(RUN_CHART_COLOR[0], 3);
    private Timer minuteTimer = null;
    private Thumbnail minutesImage;
    private Thumbnail hourlyImage;
    private Thumbnail dailyImage;
    private Thumbnail weeksImage;
    private Thumbnail weeksOfYearImage;
    private DefaultComboBoxModel modelThumbs = new DefaultComboBoxModel();
    private int loadedFiles = 5;
    private boolean loadGraphs = false;
    private long lastReloadTime = 0L;
    private ViewData vd;
    private int lines = 0;
    private double currentConsumption;
    private int m_usedInput = -1;
    private String[] externalDeviceAddress = new String[2];
    private String m_totalizedUnits = "";
    private boolean m_unitsPerPulseRead = false;
    private static final String REG_VERSION = "AppData/Utility/Version";
    private static final String REG_CURRENT_TIME = "AppData/Utility/$CurrentTime";
    private static final String REG_TITLE = "AppData/Utility/Title";
    private static final String REG_CURRENT_CONSUMPTION = "AppData/Utility/$CurrentConsumption";
    private static final String REG_RELOAD_GRAPH = "AppData/Utility/$ReloadGraph";
    private static final String REG_USED_INPUT = "AppData/Utility/UsedInput";
    private static final String REG_EXTERNALS = "AppData/Utility/Externals";
    private static final String REG_FIRST_DAY_OF_WEEK = "AppData/Utility/FirstDayOfWeek";
    private static final String REG_TOTALIZED_UNITS = "AppData/Utility/TotalizedUnits";
    private static final String logs = "logs/";
    private static final String hourlyFileName = "logs/hourly";
    private static final String monthlyFileName = "logs/";
    private static final String weeklyFileName = "logs/weekly";
    private static final int POLL_RATE = 15000;
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final Calendar currentJniorDate = Calendar.getInstance();
    private RegistryKey[] m_altTextReg = new RegistryKey[8];
    private RegistryKey[] m_instTextReg = new RegistryKey[8];
    private RegistryKey[] m_unitsPerPulseReg = new RegistryKey[8];
    private RegistryKey[] m_unitLabelReg = new RegistryKey[8];
    public JniorSession m_session = new JniorSession();
    private Connection m_connection = new Connection();
    private Login m_login = new Login();
    public BlurPane m_blur;
    public DetailView m_details = new DetailView();
    private boolean m_rebooting = false;
    private String m_codebase;
    private Device[] m_devices = null;
    private Timer watchdogTimer = null;
    private long watchdogMillis = 0L;
    private long lastWatchdogTime = 0L;
    private long lastWatchdogMillis = 0L;
    private String m_currentConsumptionString = null;
    private RegistryKey m_analogUnitsReg;
    private RegistryKey m_analogMinReg;
    private RegistryKey m_analogMaxReg;
    private RegistryKey m_analogPrecisionReg;
    private RegistryKey m_firstDayOfWeek;
    public boolean m_clientCancel = false;
    private boolean closed;
    private boolean m_initialLoad = true;
    private static final String[] DAYS_OF_WEEK = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private JPanel cardBelowGraph;
    private JPanel cardCharts;
    private Graph dailyChart;
    private Graph hourlyChart;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane2;
    private JLabel lblMaxValuePloted;
    private JLabel lblMinValuePloted;
    private JLabel lblSelectedValue;
    private JPanel loadingCharts;
    private JList lstThumbs;
    private JPanel pnlChartSelection;
    private JPanel pnlProgress;
    private JPanel pnlStats;
    private Graph runMinutesChart;
    private JLabel txtCurrentConsumption;
    private JLabel txtInstantaneous;
    private JLabel txtLoadingGraphs;
    private Graph weeklyChart;
    private Graph weeksOfYearChart;

    public UsageMeterMain() {
        this.initComponents();
        this.initMyComponents();
        this.psInstantaneous.doFactor(false);
        ThumbnailRenderer renderer = new ThumbnailRenderer();
        this.lstThumbs.setModel(this.modelThumbs);
        this.lstThumbs.setCellRenderer(renderer);
    }

    public void setConnection(String host, int port) {
        ConnectionProperties cp = new ConnectionProperties(host, port);
        this.m_session.setConnectionProperties(cp);
        this.m_session.addConnectionListener((ConnectionListener)this.m_connection);
    }

    private void promptForLogin() {
        this.m_details.setStatusText("Prompting for Login");
        try {
            Window window = SwingUtilities.getWindowAncestor(this);
            LoginDialog loginDialog = null;
            loginDialog = window instanceof Frame ? new LoginDialog((Frame)window, true) : new LoginDialog((Dialog)window, true);
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            if (loginDialog.getResult() == 1) {
                LoginProperties lp = new LoginProperties(loginDialog.getUsername(), loginDialog.getPassword());
                try {
                    this.m_session.login(lp, (LoginListener)this.m_login);
                }
                catch (NotYetConnectedException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.m_details.setStatusText("Login Canceled by User");
                this.m_details.setSubStatusText("Click here to Login");
                while (this.m_details.lblSubStatus.getMouseListeners().length > 0) {
                    this.m_details.lblSubStatus.removeMouseListener(this.m_details.lblSubStatus.getMouseListeners()[0]);
                }
                this.m_details.lblSubStatus.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        UsageMeterMain.this.promptForLogin();
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setCodebase(String codebase) {
        this.m_session.setCodebase(codebase);
        this.m_codebase = codebase;
    }

    public void startConnection() {
        this.m_details.setStatusText("Connecting...");
        JRootPane root = SwingUtilities.getRootPane(this);
        this.m_blur = new BlurPane((Container)this, this.m_details);
        root.setGlassPane((Component)this.m_blur);
        this.m_blur.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                UsageMeterMain.this.m_session.setDisplayPackets(false);
                UsageMeterMain.this.m_session.connect();
            }
        }, "Connecting").start();
    }

    public void close() {
        try {
            this.runMinutesChart.stop();
            this.hourlyChart.stop();
            this.dailyChart.stop();
            this.weeklyChart.stop();
            this.weeksOfYearChart.stop();
            this.closed = true;
            Debug.log((String)"Window Closed, Disconnecting.");
            if (this.minuteTimer != null) {
                this.minuteTimer.stop();
            }
            System.out.println(new Date() + " - Window Closed, Disconnecting.\n");
            this.m_session.disconnect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void resetFileLoadAverages() {
        this.lines = 0;
    }

    private int getNumberOfElements(int period) {
        switch (period) {
            case 11: {
                return 24;
            }
            case 5: {
                return 32;
            }
            case 7: {
                return 7;
            }
            case 3: {
                return 53;
            }
        }
        return -1;
    }

    private int getBeginning(long time, int period, int mod) {
        Calendar cal = Calendar.getInstance();
        switch (period) {
            case 11: {
                cal.setTimeInMillis(time + 60000L);
                return cal.get(period);
            }
            case 7: {
                cal.setTimeInMillis(time + 86400000L);
                int day = cal.get(period) - 2;
                return (day + mod) % mod;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    private int getEnding(long time, int period, int mod) {
        Calendar cal = Calendar.getInstance();
        switch (period) {
            case 11: {
                cal.setTimeInMillis(time + 60000L);
                return (cal.get(period) + mod - 1) % mod;
            }
            case 7: {
                cal.setTimeInMillis(time);
                int day = (cal.get(period) + 5) % 7;
                return day;
            }
            case 5: {
                return 31;
            }
            case 3: {
                return 52;
            }
        }
        return -1;
    }

    private boolean isInRange(long time, Entry entry, int period) {
        switch (period) {
            case 11: 
            case 12: {
                if (entry.time <= time - 86400000L - 3600000L) break;
                return true;
            }
            case 7: {
                Date d = new Date();
                long startOfDay = time - (time - (long)(d.getTimezoneOffset() * 60000)) % 86400000L - 604800000L;
                if (entry.time <= startOfDay) break;
                return true;
            }
            case 5: {
                if (entry.time <= time - 2678400000L - 3600000L) break;
                return true;
            }
            case 3: {
                if (entry.time <= time - 31449600000L - 604800000L) break;
                return true;
            }
        }
        return false;
    }

    private void fillSeries(InputStream is, Axis axis, PlotSeries run, int period, int length) {
        PlotSeries tempRun = new PlotSeries();
        int mod = this.getNumberOfElements(period);
        int begin = this.getBeginning(currentJniorDate.getTimeInMillis(), period, mod);
        int end = this.getEnding(currentJniorDate.getTimeInMillis(), period, mod);
        if (axis != null) {
            axis.setMin(begin);
            axis.setMax(end);
        }
        this.currentConsumption = 0.0;
        if (this.m_codebase != null) {
            long startTime = System.currentTimeMillis();
            this.readData(is, period, tempRun);
            System.out.println("Time to get file " + (System.currentTimeMillis() - startTime));
        }
        --this.loadedFiles;
        this.jProgressBar1.setValue(5 - this.loadedFiles);
        if (run != null) {
            run.removeAllElements();
        }
        for (int i = 0; i < tempRun.size(); ++i) {
            run.addElement(tempRun.elementAt(i));
        }
    }

    private DataInputStream openUrl(String url) {
        URL theURL = null;
        URLConnection conn = null;
        DataInputStream dis = null;
        try {
            url = this.m_codebase + url;
            theURL = new URL(url);
            conn = theURL.openConnection();
            conn.setUseCaches(false);
            conn.connect();
            dis = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(InputStream is, int period, PlotSeries ps) {
        block24: {
            int bytesRead;
            int index = 0;
            Entry entry = null;
            int fails = 5;
            DataInputStream inputStream = new DataInputStream(is);
            ByteBuffer sb = ByteBuffer.allocate(64000);
            byte[] bytes = new byte[1024];
            try {
                while ((bytesRead = inputStream.read(bytes, 0, bytes.length)) > 0) {
                    sb.put(bytes, 0, bytesRead);
                    sb.position();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            byte[] array = sb.array();
            ByteArrayInputStream bis = new ByteArrayInputStream(array, 0, sb.position());
            DataInputStream inputDataStream = new DataInputStream(bis);
            try {
                String line;
                inputStream.mark(1000);
                if (period == 12) {
                    while ((bytesRead = inputDataStream.read(bytes, 0, 4)) > 0) {
                        int i;
                        index = 0;
                        for (i = 0; i < 4; ++i) {
                            index = (index << 8) + (bytes[i] & 0xFF);
                        }
                        bytesRead = inputDataStream.read(bytes, 0, 26);
                        if (bytesRead == 26) {
                            entry = Entry.getEntryFromBytes(bytes);
                        }
                        if (entry == null) continue;
                        System.out.println(entry.toString());
                        for (i = 0; i < 8; ++i) {
                            entry.m_counts[i] = this.doAinScale((long)entry.m_counts[i]);
                        }
                        ps.addElement(new PlotData(entry.m_counts[this.m_usedInput - 1], (double)entry.time));
                    }
                    break block24;
                }
                while ((line = inputDataStream.readLine()) != null) {
                    if (line.equals("")) {
                        break;
                    }
                    entry = Entry.getEntryFromLine(line);
                    if (entry == null) continue;
                    System.out.println(entry.toString());
                    if (period == 3 && this.m_firstDayOfWeek.getValue() != null) {
                        for (int i = 0; i < 7; ++i) {
                            if (!this.m_firstDayOfWeek.getValue().equalsIgnoreCase(DAYS_OF_WEEK[i])) continue;
                            entry.time -= (long)(86400000 * i);
                            System.out.println("Adjusted: " + entry.toString(true));
                            break;
                        }
                    }
                    long time = entry.time;
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(time);
                    if (!this.isInRange(currentJniorDate.getTimeInMillis(), entry, period)) {
                        System.out.println("INVALID, too old.");
                        continue;
                    }
                    ps.addElement(new EntryAdapter(entry, this.m_usedInput, period));
                    ++this.lines;
                    ++index;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                    inputDataStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void getConfiguration(String address) {
        Registry registry = this.m_session.getRegistryInstance();
        RegistryRequest request = new RegistryRequest();
        this.m_analogUnitsReg = registry.getRegKey("OneWire/" + address + "/IinUnits");
        this.m_analogMinReg = registry.getRegKey("OneWire/" + address + "/IinMin");
        this.m_analogMaxReg = registry.getRegKey("OneWire/" + address + "/IinMax");
        this.m_analogPrecisionReg = registry.getRegKey("OneWire/" + address + "/IinPrecision");
        request.addKey(this.m_analogUnitsReg);
        request.addKey(this.m_analogMinReg);
        request.addKey(this.m_analogMaxReg);
        request.addKey(this.m_analogPrecisionReg);
        request.addRegistryListener((RegistryListener)this);
        try {
            registry.subscribeRegistry(request);
        }
        catch (CommandTimeoutException ex) {
            ex.printStackTrace();
        }
        catch (NotYetConnectedException ex) {
            ex.printStackTrace();
        }
    }

    public void initHourlyCharts() {
        Axis xAxis = new Axis(0.0, 23.0, 1.0);
        xAxis.setLabels(this.xHourLabels);
        xAxis.setScaleType(11);
        this.hourlyChart.addTitle("var");
        this.hourlyChart.addTitle("From var to var");
        this.hourlyChart.addTitle("x var var");
        this.hourlyChart.addTitle("var");
        this.runHours.xAxis = xAxis;
        this.hourlyChart.addSeries(this.runHours);
        this.hourlyChart.setXAxis(xAxis);
        this.hourlyChart.setElements(24);
        this.hourlyChart.setMin(0);
        this.hourlyChart.setMax(10);
        this.hourlyChart.setMinScale(1);
        this.hourlyChart.setMaxScale(1);
        this.hourlyChart.setListener(this);
        this.hourlyChart.minBarWidth = 15;
        this.hourlyChart.seriesOffset = false;
    }

    public void initWeeklyCharts() {
        Axis xAxis = new Axis(0.0, 6.0, 1.0);
        xAxis.setLabels(this.xWeekLabels);
        xAxis.setScaleType(7);
        this.weeklyChart.addTitle("var");
        this.weeklyChart.addTitle("From var to var");
        this.weeklyChart.addTitle("x var var");
        this.weeklyChart.addTitle("var");
        this.runWeeks.xAxis = xAxis;
        this.weeklyChart.addSeries(this.runWeeks);
        this.weeklyChart.setXAxis(xAxis);
        this.weeklyChart.setElements(7);
        this.weeklyChart.setMin(0);
        this.weeklyChart.setMax(10);
        this.weeklyChart.setMinScale(1);
        this.weeklyChart.setMaxScale(1);
        this.weeklyChart.setListener(this);
    }

    public void initMonthlyCharts() {
        Axis xAxis = new Axis(1.0, 31.0, 1.0);
        xAxis.setLabels(this.xDayLabels);
        xAxis.setScaleType(5);
        xAxis.setOffset(1);
        this.dailyChart.addTitle("var");
        this.dailyChart.addTitle("var");
        this.dailyChart.addTitle("x var var");
        this.dailyChart.addTitle("var");
        this.runDays.xAxis = xAxis;
        this.dailyChart.addSeries(this.runDays);
        this.dailyChart.setXAxis(xAxis);
        this.dailyChart.setElements(31);
        this.dailyChart.xGap = 0;
        this.dailyChart.setMin(0);
        this.dailyChart.setMax(10);
        this.dailyChart.setMinScale(1);
        this.dailyChart.setMaxScale(1);
        this.dailyChart.setListener(this);
        this.dailyChart.minBarWidth = 5;
        this.dailyChart.maxBarWidth = 10;
    }

    public void initYearlyCharts() {
        Axis xAxis = new Axis(0.0, 52.0, 5.0);
        xAxis.setLabels(this.xWeeksOfYearLabels);
        xAxis.setScaleType(3);
        this.weeksOfYearChart.addTitle("var");
        this.weeksOfYearChart.addTitle("var");
        this.weeksOfYearChart.addTitle("x var var");
        this.weeksOfYearChart.addTitle("var");
        this.runYear.xAxis = xAxis;
        this.weeksOfYearChart.addSeries(this.runYear);
        this.weeksOfYearChart.setXAxis(xAxis);
        this.weeksOfYearChart.setElements(53);
        this.weeksOfYearChart.xGap = 0;
        this.weeksOfYearChart.setMin(0);
        this.weeksOfYearChart.setMax(10);
        this.weeksOfYearChart.setMinScale(1);
        this.weeksOfYearChart.setMaxScale(1);
        this.weeksOfYearChart.setListener(this);
    }

    public void initGraphs() {
        Date d = new Date();
        this.runMinutesChart.addTitle("var");
        this.runMinutesChart.addTitle("var");
        this.psInstantaneous.xAxis = this.runMinutesChart.getXAxis();
        this.runMinutesChart.addSeries(this.psInstantaneous);
        this.runMinutesChart.setListener(this);
        this.initHourlyCharts();
        this.initWeeklyCharts();
        this.initMonthlyCharts();
        this.initYearlyCharts();
        this.updateThumbnail(new ActionEvent(this.runMinutesChart, 0, ""));
        this.updateThumbnail(new ActionEvent(this.hourlyChart, 0, ""));
        this.updateThumbnail(new ActionEvent(this.dailyChart, 0, ""));
        this.updateThumbnail(new ActionEvent(this.weeklyChart, 0, ""));
        this.updateThumbnail(new ActionEvent(this.weeksOfYearChart, 0, ""));
        new Thread(new Runnable(){

            public void run() {
                int last = UsageMeterMain.this.loadedFiles;
                while (UsageMeterMain.this.loadedFiles >= 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                CardLayout cl = (CardLayout)UsageMeterMain.this.cardBelowGraph.getLayout();
                cl.show(UsageMeterMain.this.cardBelowGraph, "Stats");
                UsageMeterMain.this.txtLoadingGraphs.setText("Graphs Loaded... Select one from below.");
            }
        }, "Init Graphs").start();
    }

    private long getLongAddress(String address) {
        long l = Long.parseLong(address.substring(0, 8), 16);
        l <<= 32;
        return l += Long.parseLong(address.substring(8), 16);
    }

    public void minuteUpdate() {
        if (this.minuteTimer == null) {
            this.minuteTimer = new Timer(15000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UsageMeterMain.this.updateInstantaneous();
                }
            });
            this.minuteTimer.setInitialDelay(0);
            this.minuteTimer.start();
        }
    }

    private double doAinScale(long val) {
        double d = (double)(val & 0xFFFFL) / 65520.0;
        double min = this.getMin(this.m_usedInput);
        double max = this.getMax(this.m_usedInput);
        return d * (max - min) + min;
    }

    private double getMin(int channel) {
        try {
            String value = this.m_analogMinReg.getValue();
            String[] split = value.split(",");
            value = split[(channel - 1) % 4].trim();
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private double getMax(int channel) {
        try {
            String value = this.m_analogMaxReg.getValue();
            String[] split = value.split(",");
            value = split[(channel - 1) % 4].trim();
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return 65535.0;
        }
    }

    public void reloadGraphs(final boolean fullLoad) {
        if (this.loadGraphs) {
            return;
        }
        this.loadGraphs = true;
        new Thread(new Runnable(){

            public void run() {
                while (UsageMeterMain.this.m_usedInput == -1 || !UsageMeterMain.this.m_unitsPerPulseRead) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                DataInputStream is = null;
                NumberFormat nf = NumberFormat.getInstance();
                System.out.println("Reload Graphs Running");
                UsageMeterMain.this.updateVars();
                UsageMeterMain.this.m_details.setSubStatusText("Load Hourly File");
                System.out.println("Load Hourly file");
                UsageMeterMain.this.resetFileLoadAverages();
                is = UsageMeterMain.this.openUrl("logs/hourly.csv");
                if (is != null) {
                    UsageMeterMain.this.fillSeries(is, UsageMeterMain.this.hourlyChart.getXAxis(), UsageMeterMain.this.runHours, 11, 24);
                }
                UsageMeterMain.this.updateThumbnail(new ActionEvent(UsageMeterMain.this.hourlyChart, 0, ""));
                ((UsageMeterMain)UsageMeterMain.this).hourlyChart.getVars()[3] = Integer.toString(UsageMeterMain.this.runHours.getFactor());
                if (fullLoad) {
                    UsageMeterMain.this.m_details.setSubStatusText("Load Weekly File");
                    System.out.println("Load Weekly file");
                    UsageMeterMain.this.resetFileLoadAverages();
                    is = UsageMeterMain.this.openUrl("logs/weekly.csv");
                    if (is != null) {
                        UsageMeterMain.this.fillSeries(is, UsageMeterMain.this.weeklyChart.getXAxis(), UsageMeterMain.this.runWeeks, 7, 24);
                    }
                    UsageMeterMain.this.updateThumbnail(new ActionEvent(UsageMeterMain.this.weeklyChart, 0, ""));
                    ((UsageMeterMain)UsageMeterMain.this).weeklyChart.getVars()[3] = Integer.toString(UsageMeterMain.this.runWeeks.getFactor());
                    System.out.println("Load Monthly file");
                    UsageMeterMain.this.m_details.setSubStatusText("Load Monthly File");
                    UsageMeterMain.this.resetFileLoadAverages();
                    int month = currentJniorDate.get(2);
                    if (currentJniorDate.get(5) == 1) {
                        month = (month + 11) % 12;
                    }
                    if ((is = UsageMeterMain.this.openUrl("logs/" + months[month] + ".csv")) != null) {
                        UsageMeterMain.this.fillSeries(is, UsageMeterMain.this.dailyChart.getXAxis(), UsageMeterMain.this.runDays, 5, 24);
                    }
                    UsageMeterMain.this.updateThumbnail(new ActionEvent(UsageMeterMain.this.dailyChart, 0, ""));
                    ((UsageMeterMain)UsageMeterMain.this).dailyChart.getVars()[2] = Integer.toString(UsageMeterMain.this.runDays.getFactor());
                    System.out.println("Load Yearly file");
                    UsageMeterMain.this.m_details.setSubStatusText("Load Yearly File");
                    UsageMeterMain.this.resetFileLoadAverages();
                    Calendar cal = Calendar.getInstance();
                    is = UsageMeterMain.this.openUrl("logs/" + cal.get(1) + ".csv");
                    if (is != null) {
                        UsageMeterMain.this.fillSeries(is, UsageMeterMain.this.weeksOfYearChart.getXAxis(), UsageMeterMain.this.runYear, 3, 53);
                    }
                    UsageMeterMain.this.updateThumbnail(new ActionEvent(UsageMeterMain.this.weeksOfYearChart, 0, ""));
                    ((UsageMeterMain)UsageMeterMain.this).weeksOfYearChart.getVars()[2] = Integer.toString(UsageMeterMain.this.runYear.getFactor());
                    UsageMeterMain.this.minuteUpdate();
                    if (UsageMeterMain.this.m_initialLoad) {
                        System.out.println("Load Minutes file");
                        UsageMeterMain.this.m_details.setSubStatusText("Load Instantaneous File");
                        String ip = UsageMeterMain.this.m_codebase.substring(7, UsageMeterMain.this.m_codebase.length() - 1);
                        DumpConnection dump = new DumpConnection(ip, 8999, "");
                        if (dump.in() != null) {
                            UsageMeterMain.this.fillSeries(dump.in(), null, UsageMeterMain.this.psInstantaneous, 12, 24);
                            dump.close();
                        }
                        UsageMeterMain.this.m_initialLoad = false;
                    }
                    UsageMeterMain.this.updateThumbnail(new ActionEvent(UsageMeterMain.this.runMinutesChart, 0, ""));
                    double min = Double.MAX_VALUE;
                    double max = Double.MIN_VALUE;
                    for (int i = 0; i < UsageMeterMain.this.psInstantaneous.size(); ++i) {
                        PlotData pd = (PlotData)UsageMeterMain.this.psInstantaneous.get(i);
                        if (pd.getDouble() > max) {
                            max = pd.getDouble();
                        }
                        if (!(pd.getDouble() < min)) continue;
                        min = pd.getDouble();
                    }
                    String units = "";
                    try {
                        String[] split = UsageMeterMain.this.m_analogUnitsReg.getValue().split(",");
                        units = split[UsageMeterMain.this.m_usedInput - 1].trim();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    DecimalFormat df = new DecimalFormat("0.00");
                    UsageMeterMain.this.runMinutesChart.setMouseOver("<html>Min: " + df.format(min) + " " + units + "<br>Max: " + df.format(max) + " " + units + "</html>");
                    if (UsageMeterMain.this.psInstantaneous.size() > 0) {
                        double earliest = 9.223372036854776E18;
                        for (int i = 0; i < UsageMeterMain.this.psInstantaneous.size(); ++i) {
                            if (!(((PlotData)UsageMeterMain.this.psInstantaneous.elementAt(i)).getTime() < earliest)) continue;
                            earliest = ((PlotData)UsageMeterMain.this.psInstantaneous.elementAt(i)).getTime();
                        }
                        UsageMeterMain.this.runMinutesChart.getXAxis().setMin(earliest);
                    }
                    UsageMeterMain.this.m_blur.setVisible(false);
                    try {
                        CardLayout cl = (CardLayout)UsageMeterMain.this.cardCharts.getLayout();
                        cl.show(UsageMeterMain.this.cardCharts, "runMinutes");
                        Thread.sleep(500L);
                        cl.show(UsageMeterMain.this.cardCharts, "hourlyChart");
                        Thread.sleep(500L);
                        cl.show(UsageMeterMain.this.cardCharts, "dailyChart");
                        Thread.sleep(500L);
                        cl.show(UsageMeterMain.this.cardCharts, "weeklyChart");
                        Thread.sleep(500L);
                        cl.show(UsageMeterMain.this.cardCharts, "weeksOfYearChart");
                        Thread.sleep(500L);
                        cl.show(UsageMeterMain.this.cardCharts, "hourlyChart");
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                UsageMeterMain.this.loadedFiles = -1;
                UsageMeterMain.this.loadGraphs = false;
                UsageMeterMain.this.lstThumbs.setEnabled(true);
                UsageMeterMain.this.jComboBox1.setEnabled(true);
                UsageMeterMain.this.m_blur.setVisible(false);
                System.out.println("Reload Graphs Done!");
            }
        }, "Reload Graphs").start();
    }

    public void updateVars() {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy HH:00 aa");
        String[] vars = new String[]{graphTitle, "", "", "", "", ""};
        if (this.runMinutesChart.getVars() != null) {
            vars[1] = this.m_instTextReg[this.m_usedInput - 1].getValue();
        }
        this.runMinutesChart.setVars(vars);
        if (this.hourlyChart.getVars() != null) {
            vars[1] = formatter.format((Object)new Date(currentJniorDate.getTimeInMillis() - 86400000L));
            vars[2] = formatter.format((Object)currentJniorDate.getTime());
            vars[3] = Integer.toString(this.runHours.getFactor());
            vars[4] = this.m_totalizedUnits;
            vars[5] = this.m_altTextReg[this.m_usedInput - 1].getValue();
        }
        this.hourlyChart.setVars(vars);
        formatter = new SimpleDateFormat("MM/dd/yy");
        if (this.weeklyChart.getVars() != null) {
            vars[1] = formatter.format((Object)new Date(currentJniorDate.getTimeInMillis() - 604800000L + 86400000L));
            vars[2] = formatter.format((Object)currentJniorDate.getTime());
            vars[3] = Integer.toString(this.runWeeks.getFactor());
            vars[4] = this.m_totalizedUnits;
            vars[5] = this.m_altTextReg[this.m_usedInput - 1].getValue();
        }
        this.weeklyChart.setVars(vars);
        formatter = new SimpleDateFormat("MMMM yyyy");
        if (this.dailyChart.getVars() != null) {
            Calendar tempCal = Calendar.getInstance();
            tempCal.setTime(currentJniorDate.getTime());
            if (tempCal.get(5) == 1) {
                tempCal.add(5, -1);
            }
            vars[1] = formatter.format((Object)tempCal.getTime());
            vars[2] = Integer.toString(this.runWeeks.getFactor());
            vars[3] = this.m_totalizedUnits;
            vars[4] = this.m_altTextReg[this.m_usedInput - 1].getValue();
            int numberOfDays = tempCal.getMaximum(5);
            this.runDays.xAxis = new Axis(1.0, numberOfDays, 1.0);
        }
        this.dailyChart.setVars(vars);
        formatter = new SimpleDateFormat("yyyy");
        if (this.weeksOfYearChart.getVars() != null) {
            vars[1] = formatter.format((Object)currentJniorDate.getTime());
            vars[2] = Integer.toString(this.runYear.getFactor());
            vars[3] = this.m_totalizedUnits;
            vars[4] = this.m_altTextReg[this.m_usedInput - 1].getValue();
        }
        this.weeksOfYearChart.setVars(vars);
    }

    public void updateThumbnail(ActionEvent evt) {
        this.actionPerformed(evt);
    }

    public void initMyComponents() {
        this.jProgressBar1.setMaximum(this.loadedFiles);
        this.minutesImage = new Thumbnail();
        this.hourlyImage = new Thumbnail();
        this.dailyImage = new Thumbnail();
        this.weeksImage = new Thumbnail();
        this.weeksOfYearImage = new Thumbnail();
        this.minutesImage.setToolTipText("Instantaneous");
        this.hourlyImage.setToolTipText("Hourly Usage");
        this.dailyImage.setToolTipText("Daily Usage");
        this.weeksImage.setToolTipText("Weekly Usage");
        this.weeksOfYearImage.setToolTipText("Yearly Usage");
        this.modelThumbs.addElement(this.minutesImage);
        this.modelThumbs.addElement(this.hourlyImage);
        this.modelThumbs.addElement(this.weeksImage);
        this.modelThumbs.addElement(this.dailyImage);
        this.modelThumbs.addElement(this.weeksOfYearImage);
        for (int i = 0; i < this.modelThumbs.getSize(); ++i) {
            ((Thumbnail)this.modelThumbs.getElementAt(i)).repaint();
        }
        this.minutesImage.setListener(this);
        this.hourlyImage.setListener(this);
        this.weeksImage.setListener(this);
        this.dailyImage.setListener(this);
        this.weeksOfYearImage.setListener(this);
        this.lstThumbs.repaint();
        this.setPanelText(1, "");
    }

    public void actionPerformed(ActionEvent e) {
        Graph gph = (Graph)e.getSource();
        Thumbnail pnl = null;
        if (gph == this.runMinutesChart) {
            pnl = this.minutesImage;
        } else if (gph == this.hourlyChart) {
            pnl = this.hourlyImage;
        } else if (gph == this.dailyChart) {
            pnl = this.dailyImage;
        } else if (gph == this.weeklyChart) {
            pnl = this.weeksImage;
        } else if (gph == this.weeksOfYearChart) {
            pnl = this.weeksOfYearImage;
        }
        if (pnl != null) {
            Graphics g = pnl.getGraphics();
            if (e.getActionCommand().equals("") && g != null) {
                gph.paint(g);
                gph.repaint();
            } else if (e.getActionCommand().equals("Update")) {
                pnl.setThumbnail(gph.getThumbnail());
                double min = gph.GetMinimumValuePloted();
                double max = gph.GetMaximumValuePloted();
                double value = gph.GetSelectedValue();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                String units = "";
                try {
                    String[] split = this.m_analogUnitsReg.getValue().split(",");
                    units = split[(this.m_usedInput - 1) % 4].trim();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.lblMinValuePloted.setText(nf.format(min) + " " + units);
                this.lblMaxValuePloted.setText(nf.format(max) + " " + units);
                this.lblSelectedValue.setText(nf.format(value) + " " + units);
            } else if (e.getActionCommand().equals("Print Current")) {
                this.doPrint((Graph)e.getSource());
            } else if (e.getActionCommand().equals("Print All")) {
                this.doPrint(null);
            }
        }
        this.lstThumbs.repaint();
    }

    public void doPrint(Graph source) {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pf = pjob.defaultPage();
        if (source != null) {
            pjob.setPageable(source);
        } else {
            pjob.setPageable(this);
        }
        try {
            if (pjob.printDialog()) {
                pjob.print();
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
    }

    public int getNumberOfPages() {
        return 10;
    }

    public PageFormat getPageFormat(int param) throws IndexOutOfBoundsException {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        return pjob.defaultPage();
    }

    public Printable getPrintable(int param) throws IndexOutOfBoundsException {
        switch (param) {
            case 0: {
                return this.hourlyChart;
            }
            case 1: {
                return this.dailyChart;
            }
            case 2: {
                return this.weeklyChart;
            }
            case 3: {
                return this.weeksOfYearChart;
            }
        }
        return null;
    }

    public void newChartSelected(JPanel pnl) {
        CardLayout cl = (CardLayout)this.cardCharts.getLayout();
        if (pnl == this.minutesImage) {
            cl.show(this.cardCharts, "runMinutes");
        } else if (pnl == this.hourlyImage) {
            cl.show(this.cardCharts, "hourlyChart");
        } else if (pnl == this.dailyImage) {
            cl.show(this.cardCharts, "dailyChart");
        } else if (pnl == this.weeksImage) {
            cl.show(this.cardCharts, "weeklyChart");
        } else if (pnl == this.weeksOfYearImage) {
            cl.show(this.cardCharts, "weeksOfYearChart");
        }
    }

    private void setChartHelp() {
        String toolTipHelp = "<html></html>";
        this.runMinutesChart.setMouseOver("<html>Min: <br>Max:</html>");
        this.hourlyChart.setMouseOver(toolTipHelp);
        this.weeklyChart.setMouseOver(toolTipHelp);
        this.dailyChart.setMouseOver(toolTipHelp);
        this.weeksOfYearChart.setMouseOver(toolTipHelp);
    }

    public void selected(Thumbnail thumb) {
        this.newChartSelected(thumb);
    }

    public void monitorWatchdog() {
        try {
            Registry registry = this.m_session.getRegistryInstance();
            RegistryRequest request = new RegistryRequest();
            request.addKey(registry.getRegKey("AppData/Utility/$Watchdog"));
            request.addKey(registry.getRegKey("AppData/Utility/$Quit"));
            request.addRegistryListener((RegistryListener)this);
            registry.subscribeRegistry(request, false);
        }
        catch (NotYetConnectedException ex) {
            ex.printStackTrace();
        }
        catch (CommandTimeoutException ex) {
            ex.printStackTrace();
        }
        if (this.watchdogTimer == null) {
            this.watchdogTimer = new Timer(1500, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (System.currentTimeMillis() - UsageMeterMain.this.lastWatchdogTime <= 120000L && UsageMeterMain.this.lastWatchdogMillis != 0L) {
                            if (UsageMeterMain.this.labelStatus.getBackground() == Color.GREEN) {
                                UsageMeterMain.this.labelStatus.setBackground(Color.WHITE);
                            } else {
                                UsageMeterMain.this.labelStatus.setBackground(Color.GREEN);
                            }
                        } else {
                            UsageMeterMain.this.labelStatus.setBackground(Color.RED);
                        }
                        if (UsageMeterMain.this.watchdogMillis != UsageMeterMain.this.lastWatchdogMillis) {
                            if (UsageMeterMain.this.lastWatchdogMillis != 0L) {
                                UsageMeterMain.this.lastWatchdogTime = System.currentTimeMillis();
                            }
                            UsageMeterMain.this.lastWatchdogMillis = UsageMeterMain.this.watchdogMillis;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println(nfe.toString());
                    }
                }
            });
        }
        this.watchdogTimer.start();
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtCurrentConsumption = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel3 = new JLabel();
        this.txtInstantaneous = new JLabel();
        this.jPanel6 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanel3 = new JPanel();
        this.cardCharts = new JPanel();
        this.loadingCharts = new JPanel();
        this.txtLoadingGraphs = new JLabel();
        this.jPanel2 = new JPanel();
        this.runMinutesChart = new Graph();
        this.cardBelowGraph = new JPanel();
        this.pnlProgress = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.pnlStats = new JPanel();
        this.jLabel2 = new JLabel();
        this.lblMinValuePloted = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblMaxValuePloted = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblSelectedValue = new JLabel();
        this.hourlyChart = new Graph();
        this.dailyChart = new Graph();
        this.weeklyChart = new Graph();
        this.weeksOfYearChart = new Graph();
        this.jPanel1 = new JPanel();
        this.pnlChartSelection = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstThumbs = new JList();
        this.setOpaque(false);
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(93, 35));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new GridLayout(1, 0));
        this.jPanel9.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.jPanel9.setLayout(new BorderLayout());
        this.jLabel1.setText("Current Hour: ");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(1, 15, 1, 1));
        this.jPanel9.add((Component)this.jLabel1, "West");
        this.txtCurrentConsumption.setForeground(new Color(0, 51, 102));
        this.txtCurrentConsumption.setText("   ");
        this.txtCurrentConsumption.setMaximumSize(new Dimension(300, 14));
        this.jPanel9.add((Component)this.txtCurrentConsumption, "Center");
        this.jPanel5.add(this.jPanel9);
        this.jPanel11.setLayout(new BorderLayout());
        this.jLabel3.setText("Instantaneous: ");
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(1, 15, 1, 1));
        this.jPanel11.add((Component)this.jLabel3, "West");
        this.txtInstantaneous.setForeground(new Color(0, 51, 102));
        this.txtInstantaneous.setText("     ");
        this.jPanel11.add((Component)this.txtInstantaneous, "Center");
        this.jPanel5.add(this.jPanel11);
        this.jPanel4.add((Component)this.jPanel5, "Center");
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 10));
        this.jPanel6.setLayout(new FlowLayout(2));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Channel 1", "Channel 2", "Channel 3", "Channel 4", "Channel 5", "Channel 6", "Channel 7", "Channel 8"}));
        this.jComboBox1.setEnabled(false);
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsageMeterMain.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jComboBox1);
        this.jPanel4.add((Component)this.jPanel6, "East");
        this.jPanel7.add((Component)this.jPanel4, "South");
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new BorderLayout());
        this.cardCharts.setLayout(new CardLayout());
        this.loadingCharts.setLayout(new BorderLayout());
        this.txtLoadingGraphs.setHorizontalAlignment(0);
        this.txtLoadingGraphs.setText("<html>Loading Graph Data...  Please Wait. <br><br><br>Right Click a graph for more options</html>");
        this.txtLoadingGraphs.setHorizontalTextPosition(0);
        this.loadingCharts.add((Component)this.txtLoadingGraphs, "Center");
        this.cardCharts.add((Component)this.loadingCharts, "loadingCharts");
        this.jPanel2.setLayout(new BorderLayout());
        this.runMinutesChart.setLayout(null);
        this.jPanel2.add((Component)this.runMinutesChart, "Center");
        this.cardBelowGraph.setLayout(new CardLayout());
        this.jProgressBar1.setPreferredSize(new Dimension(200, 18));
        this.pnlProgress.add(this.jProgressBar1);
        this.cardBelowGraph.add((Component)this.pnlProgress, "Loading");
        this.jLabel2.setText("Minimum: ");
        this.pnlStats.add(this.jLabel2);
        this.lblMinValuePloted.setText(" ");
        this.pnlStats.add(this.lblMinValuePloted);
        this.jLabel4.setText("     Maximum: ");
        this.pnlStats.add(this.jLabel4);
        this.lblMaxValuePloted.setText(" ");
        this.pnlStats.add(this.lblMaxValuePloted);
        this.jLabel5.setText("     Value: ");
        this.pnlStats.add(this.jLabel5);
        this.lblSelectedValue.setText(" ");
        this.pnlStats.add(this.lblSelectedValue);
        this.cardBelowGraph.add((Component)this.pnlStats, "Stats");
        this.jPanel2.add((Component)this.cardBelowGraph, "South");
        this.cardCharts.add((Component)this.jPanel2, "runMinutes");
        this.hourlyChart.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UsageMeterMain.this.chartSelected(evt);
            }
        });
        this.hourlyChart.setLayout(null);
        this.cardCharts.add((Component)this.hourlyChart, "hourlyChart");
        this.dailyChart.setLayout(null);
        this.cardCharts.add((Component)this.dailyChart, "dailyChart");
        this.weeklyChart.setLayout(null);
        this.cardCharts.add((Component)this.weeklyChart, "weeklyChart");
        this.weeksOfYearChart.setLayout(null);
        this.cardCharts.add((Component)this.weeksOfYearChart, "weeksOfYearChart");
        this.jPanel3.add((Component)this.cardCharts, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.pnlChartSelection.setBorder(BorderFactory.createTitledBorder("Select a Chart"));
        this.pnlChartSelection.setLayout(new BorderLayout());
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setHorizontalScrollBarPolicy(32);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jScrollPane2.setMaximumSize(new Dimension(50, 75));
        this.jScrollPane2.setMinimumSize(new Dimension(50, 75));
        this.jScrollPane2.setPreferredSize(new Dimension(100, 75));
        this.jScrollPane2.setWheelScrollingEnabled(false);
        this.lstThumbs.setBackground(new Color(226, 226, 226));
        this.lstThumbs.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lstThumbs.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstThumbs.setSelectionMode(0);
        this.lstThumbs.setEnabled(false);
        this.lstThumbs.setLayoutOrientation(2);
        this.lstThumbs.setMaximumSize(new Dimension(165, 60));
        this.lstThumbs.setMinimumSize(new Dimension(15, 16));
        this.lstThumbs.setVisibleRowCount(1);
        this.jScrollPane2.setViewportView(this.lstThumbs);
        this.pnlChartSelection.add((Component)this.jScrollPane2, "South");
        this.jPanel1.add((Component)this.pnlChartSelection, "South");
        this.jPanel3.add((Component)this.jPanel1, "South");
        this.jPanel7.add((Component)this.jPanel3, "Center");
        this.add((Component)this.jPanel7, "Center");
    }

    private void chartSelected(MouseEvent evt) {
        PlotSeries[] ps = new PlotSeries[]{null, null, null};
        PlotSeries labels = null;
        if (evt.getClickCount() < 2) {
            return;
        }
        if (evt.getSource() == this.hourlyChart) {
            labels = this.xHourLabels;
            ps[0] = this.runHours;
            ps[1] = this.runHours;
            ps[2] = this.runHours;
        }
        if (this.vd == null) {
            this.vd = new ViewData();
        }
        if (ps != null && labels != null) {
            this.vd.loadData(labels, ps);
            this.vd.show();
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        try {
            String selectedItem = this.jComboBox1.getSelectedItem().toString();
            this.m_usedInput = Integer.parseInt(selectedItem.substring(selectedItem.lastIndexOf(" ") + 1));
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[this.m_usedInput - 1].getValue();
            this.lstThumbs.setEnabled(false);
            this.jComboBox1.setEnabled(false);
            this.m_details.setStatusText("Loading Graph Data...  Please Wait.");
            this.m_blur.setVisible(true);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    UsageMeterMain.this.runMinutesChart.stop();
                    UsageMeterMain.this.updateInstantaneous();
                    UsageMeterMain.this.updateInstantaneousChart();
                    UsageMeterMain.this.m_initialLoad = true;
                    UsageMeterMain.this.reloadGraphs(true);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    Calendar _cal = Calendar.getInstance();
                    _cal.setFirstDayOfWeek(4);
                    for (int i = 0; i < 10; ++i) {
                        System.out.println(_cal.getTime().toString() + " week: " + _cal.get(3));
                        _cal.setTimeInMillis(_cal.getTimeInMillis() + 86400000L);
                    }
                    final JFrame f = new JFrame("");
                    Container content = f.getContentPane();
                    final JTabbedPane tabs = new JTabbedPane();
                    content.add(tabs);
                    final UsageMeterMain main = new UsageMeterMain();
                    f.setSize(700, 625);
                    f.setVisible(true);
                    CancelKeyListener ckl = new CancelKeyListener();
                    ckl.main = main;
                    tabs.addKeyListener(ckl);
                    f.addWindowListener(new WindowAdapter(){

                        public void windowOpened(WindowEvent e) {
                            String host = "192.168.1.102";
                            host = "10.0.0.241";
                            if ((host = JOptionPane.showInputDialog(f, "Host Name", host)) != null) {
                                tabs.addTab(host, main);
                                main.setCodebase("http://" + host + "/");
                                main.setConnection(host, 0);
                                main.startConnection();
                                main.initGraphs();
                            }
                        }

                        public void windowClosing(WindowEvent e) {
                            super.windowClosing(e);
                            main.close();
                            f.dispose();
                            int count = Thread.activeCount();
                            System.out.println("Active Threads: " + count);
                            Thread[] thds = new Thread[count];
                            Thread.enumerate(thds);
                            for (int i = 0; i < count; ++i) {
                                System.out.println(thds[i]);
                            }
                        }
                    });
                    tabs.addMouseListener(new MouseAdapter(){

                        public void mouseReleased(MouseEvent evt) {
                            if (evt.isPopupTrigger()) {
                                JMenuItem menuItem;
                                JPopupMenu commandPopup = new JPopupMenu();
                                if (tabs.getTabCount() > 0) {
                                    menuItem = new JMenuItem("Close Tab");
                                    menuItem.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent e) {
                                            UsageMeterMain main = (UsageMeterMain)tabs.getSelectedComponent();
                                            main.close();
                                            tabs.remove(tabs.getSelectedIndex());
                                        }
                                    });
                                    commandPopup.add(menuItem);
                                }
                                menuItem = new JMenuItem("New Tab");
                                menuItem.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        String host = "";
                                        host = JOptionPane.showInputDialog(f, "IP Address", host);
                                        for (int i = 0; i < tabs.getTabCount(); ++i) {
                                            if (!tabs.getTitleAt(i).equals(host)) continue;
                                            return;
                                        }
                                        if (host != null) {
                                            UsageMeterMain newMain = new UsageMeterMain();
                                            tabs.addTab(host, newMain);
                                            KeyListener[] kls = tabs.getKeyListeners();
                                            for (int i = 0; i < kls.length; ++i) {
                                                tabs.removeKeyListener(kls[i]);
                                            }
                                            CancelKeyListener KL = new CancelKeyListener();
                                            KL.main = newMain;
                                            tabs.addKeyListener(KL);
                                            newMain.setCodebase("http://" + host + "/");
                                            newMain.setConnection(host, 0);
                                            newMain.startConnection();
                                            newMain.initGraphs();
                                        }
                                    }
                                });
                                commandPopup.add(menuItem);
                                commandPopup.show(evt.getComponent(), evt.getX(), evt.getY());
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void enumerationReceived(EventObject evt, Device[] devices) {
    }

    public void onRegistryKeyReceived(EventObject evt, RegistryKey regKey) {
        if (regKey.getKey().lastIndexOf(REG_CURRENT_TIME) >= 0) {
            if (regKey.getValue().equals("")) {
                currentJniorDate.setTimeInMillis(System.currentTimeMillis());
            } else {
                currentJniorDate.setTimeInMillis(Long.parseLong(regKey.getValue()));
            }
            this.setChartHelp();
        } else if (regKey.getKey().lastIndexOf(REG_TITLE) >= 0) {
            graphTitle = regKey.getValue();
            this.updateVars();
        } else if (regKey.getKey().lastIndexOf(REG_CURRENT_CONSUMPTION) >= 0) {
            try {
                this.m_currentConsumptionString = regKey.getValue();
                if (this.m_usedInput > 0) {
                    if (regKey.getValue().equals("")) {
                        this.currentConsumption = 0.0;
                    } else {
                        String[] split = this.m_currentConsumptionString.split(", ");
                        this.currentConsumption = Double.parseDouble(split[this.m_usedInput - 1]);
                    }
                    this.currentConsumption *= Entry.m_unitsPerPulse;
                    this.txtCurrentConsumption.setText(" " + Integer.toString((int)this.currentConsumption) + " " + this.m_unitLabelReg[this.m_usedInput - 1].getValue());
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        } else if (regKey.getKey().lastIndexOf(REG_RELOAD_GRAPH) >= 0) {
            System.out.println("Reload graphs recieved from the JNIOR.\nChecking to see if we are currently loading the graphs = " + this.loadGraphs);
            if (this.loadGraphs) {
                return;
            }
            long reloadTime = Long.parseLong(regKey.getValue());
            System.out.println("Is the last time we reloaded the graphs the same as the time we are recieving from the JNIOR? " + (reloadTime == this.lastReloadTime));
            currentJniorDate.setTimeInMillis(Long.parseLong(regKey.getValue()));
            System.out.println("Current Jnior Time is " + currentJniorDate.getTime());
            if (reloadTime != this.lastReloadTime) {
                boolean newDay = reloadTime % 86400L < this.lastReloadTime % 86400L;
                this.reloadGraphs(newDay);
                this.lastReloadTime = reloadTime;
            }
        } else if (regKey.getKey().equals(REG_USED_INPUT)) {
            if (!regKey.getValue().equals("")) {
                this.m_usedInput = Integer.parseInt(regKey.getValue());
                this.jComboBox1.setSelectedIndex(this.m_usedInput - 1);
                if (this.m_usedInput > 0 && this.m_currentConsumptionString != null) {
                    String[] split = this.m_currentConsumptionString.split(", ");
                    this.currentConsumption = Double.parseDouble(split[this.m_usedInput - 1]);
                    this.txtCurrentConsumption.setText(" " + Integer.toString((int)this.currentConsumption));
                }
            }
        } else if (regKey.getKey().equals(REG_EXTERNALS)) {
            if (!regKey.getKey().equals("")) {
                int commaPos = regKey.getValue().indexOf(",");
                if (commaPos > 0) {
                    this.externalDeviceAddress[0] = regKey.getValue().substring(0, commaPos);
                    this.externalDeviceAddress[1] = regKey.getValue().substring(commaPos + 2);
                } else {
                    this.externalDeviceAddress[0] = regKey.getValue();
                }
            }
        } else if (regKey.equals(this.m_unitsPerPulseReg[0]) && this.m_usedInput == 1) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[1]) && this.m_usedInput == 2) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[2]) && this.m_usedInput == 3) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[3]) && this.m_usedInput == 4) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[4]) && this.m_usedInput == 5) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[5]) && this.m_usedInput == 6) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[6]) && this.m_usedInput == 7) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception ex) {}
        } else if (regKey.equals(this.m_unitsPerPulseReg[7]) && this.m_usedInput == 8) {
            this.m_unitsPerPulseRead = true;
            Entry.m_unitsPerPulse = 1.0;
            try {
                Entry.m_unitsPerPulse = Double.parseDouble(this.m_unitsPerPulseReg[this.m_usedInput - 1].getValue());
            }
            catch (Exception exception) {}
        } else if (regKey.equals(this.m_unitLabelReg[0]) && this.m_usedInput == 1) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[0].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[1]) && this.m_usedInput == 2) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[1].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[2]) && this.m_usedInput == 3) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[2].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[3]) && this.m_usedInput == 4) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[3].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[4]) && this.m_usedInput == 5) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[4].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[5]) && this.m_usedInput == 6) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[5].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[6]) && this.m_usedInput == 7) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[6].getValue();
        } else if (regKey.equals(this.m_unitLabelReg[7]) && this.m_usedInput == 8) {
            EntryAdapter.m_unitLabel = this.m_unitLabelReg[7].getValue();
        } else if (regKey.getKey().equals(REG_TOTALIZED_UNITS)) {
            this.m_totalizedUnits = regKey.getValue();
        } else if (regKey.getKey().equals(REG_VERSION)) {
            this.setPanelText(2, "vers. jnior " + regKey.getValue() + " : web " + VERSION);
        } else if (regKey.getKey().indexOf("$Watchdog") >= 0) {
            if (regKey.getValue().equals("")) {
                return;
            }
            this.watchdogMillis = Long.parseLong(regKey.getValue());
        } else if (regKey == this.m_analogUnitsReg) {
            this.updateInstantaneous();
        } else if (regKey == this.m_analogMaxReg) {
            this.updateInstantaneousChart();
            this.updateInstantaneous();
        } else if (regKey.getKey().lastIndexOf("IinMin") > 0) {
            this.updateInstantaneousChart();
            this.updateInstantaneous();
        }
        if (this.loadedFiles == -1) {
            this.updateVars();
        }
    }

    private void updateInstantaneousChart() {
        String value = this.m_analogMaxReg.getValue();
        if (!value.equals("")) {
            double max = this.getMax(this.m_usedInput);
            this.runMinutesChart.setMax((int)max);
            this.runMinutesChart.repaint();
        } else {
            this.runMinutesChart.setMax(100);
        }
        if (this.runMinutesChart.Max() >= 50000) {
            this.runMinutesChart.setMinScale(5000);
            this.runMinutesChart.setMaxScale(5000);
        } else if (this.runMinutesChart.Max() >= 25000) {
            this.runMinutesChart.setMinScale(2500);
            this.runMinutesChart.setMaxScale(2500);
        } else if (this.runMinutesChart.Max() >= 10000) {
            this.runMinutesChart.setMinScale(1000);
            this.runMinutesChart.setMaxScale(1000);
        } else if (this.runMinutesChart.Max() >= 5000) {
            this.runMinutesChart.setMinScale(500);
            this.runMinutesChart.setMaxScale(500);
        } else if (this.runMinutesChart.Max() >= 2500) {
            this.runMinutesChart.setMinScale(250);
            this.runMinutesChart.setMaxScale(250);
        } else if (this.runMinutesChart.Max() >= 1000) {
            this.runMinutesChart.setMinScale(100);
            this.runMinutesChart.setMaxScale(100);
        } else if (this.runMinutesChart.Max() >= 500) {
            this.runMinutesChart.setMinScale(50);
            this.runMinutesChart.setMaxScale(50);
        } else if (this.runMinutesChart.Max() >= 250) {
            this.runMinutesChart.setMinScale(25);
            this.runMinutesChart.setMaxScale(25);
        } else if (this.runMinutesChart.Max() >= 100) {
            this.runMinutesChart.setMinScale(10);
            this.runMinutesChart.setMaxScale(10);
        } else if (this.runMinutesChart.Max() >= 25) {
            this.runMinutesChart.setMinScale(5);
            this.runMinutesChart.setMaxScale(5);
        } else {
            this.runMinutesChart.setMinScale(1);
            this.runMinutesChart.setMaxScale(1);
        }
        value = this.m_analogMinReg.getValue();
        if (!value.equals("")) {
            double min = this.getMin(this.m_usedInput);
            this.runMinutesChart.setMin((int)min);
            this.runMinutesChart.repaint();
        } else {
            this.runMinutesChart.setMin(0);
        }
    }

    private void updateInstantaneous() {
        if (this.m_usedInput < 0) {
            return;
        }
        ExternalTypeFE[] devices = null;
        try {
            long start = System.currentTimeMillis();
            int index = (this.m_usedInput - 1) / 4;
            long l = this.getLongAddress(this.externalDeviceAddress[index]);
            double count = 0.0;
            long time = 0L;
            if (!this.runMinutesChart.started) {
                this.getConfiguration(this.externalDeviceAddress[index]);
                this.runMinutesChart.start();
            }
            devices = new ExternalTypeFE[2];
            Hashtable deviceHash = this.m_session.getDevices();
            devices[index] = (ExternalTypeFE)deviceHash.get(new Long(l));
            if (devices[index] == null) {
                this.txtInstantaneous.setText(" -- ");
                return;
            }
            devices[index].read();
            block14: for (int i = 0; i < devices.length; ++i) {
                switch (this.m_usedInput - 1) {
                    case 0: {
                        count = devices[0].getIn(1);
                        continue block14;
                    }
                    case 1: {
                        count = devices[0].getIn(2);
                        continue block14;
                    }
                    case 2: {
                        count = devices[0].getIn(3);
                        continue block14;
                    }
                    case 3: {
                        count = devices[0].getIn(4);
                        continue block14;
                    }
                    case 4: {
                        count = devices[1].getIn(1);
                        continue block14;
                    }
                    case 5: {
                        count = devices[1].getIn(2);
                        continue block14;
                    }
                    case 6: {
                        count = devices[1].getIn(3);
                        continue block14;
                    }
                    case 7: {
                        count = devices[1].getIn(4);
                    }
                }
            }
            long now = currentJniorDate.getTimeInMillis();
            count = this.doAinScale((long)count);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(1);
            String units = "";
            try {
                String[] split = this.m_analogUnitsReg.getValue().split(",");
                units = split[(this.m_usedInput - 1) % 4].trim();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.txtInstantaneous.setText(nf.format(count) + " " + units);
            this.psInstantaneous.addElement(new PlotData(count, (double)now));
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (int i = 0; i < this.psInstantaneous.size(); ++i) {
                PlotData pd = (PlotData)this.psInstantaneous.get(i);
                if (pd.getDouble() > max) {
                    max = pd.getDouble();
                }
                if (!(pd.getDouble() < min)) continue;
                min = pd.getDouble();
            }
            DecimalFormat df = new DecimalFormat("0.00");
            this.runMinutesChart.setMouseOver("<html>Min: " + df.format(min) + " " + units + "<br>Max: " + df.format(max) + " " + units + "</html>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onRegistryListReceived(EventObject evt, String parent, String[] nodes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static /* synthetic */ Device[] access$3702(UsageMeterMain x0, Device[] x1) {
        x0.m_devices = x1;
        return x1;
    }

    class Login
    implements LoginListener {
        Login() {
        }

        public void onLoginSent(EventObject evt, LoginProperties loginProperties) {
            System.out.println(new Date().toString() + " - Login Sent.\n");
            UsageMeterMain.this.m_details.setSubStatusText("Login Sent...");
        }

        public void onLoginSuccess(EventObject evt, LoginProperties loginProperties) {
            String s = "Login Success.  Login Level is " + loginProperties.getLoginLevel();
            System.out.println(new Date().toString() + " - " + s);
            UsageMeterMain.this.m_details.setStatusText(s);
            if (Math.abs(loginProperties.getLoginLevel()) < 128) {
                JOptionPane.showMessageDialog(UsageMeterMain.this, "Must be Administrator", "Must be Administrator", 0);
                UsageMeterMain.this.promptForLogin();
            }
            int level = Math.abs(loginProperties.getLoginLevel());
            UsageMeterMain.this.m_blur.setVisible(false);
            try {
                UsageMeterMain.this.m_session.setUnsolicitedMessages(false);
                UsageMeterMain.this.m_session.addEnumerationListener((EnumerationListener)UsageMeterMain.this);
                UsageMeterMain.access$3702(UsageMeterMain.this, UsageMeterMain.this.m_session.enumerate(3));
            }
            catch (CommandTimeoutException ex) {
                ex.printStackTrace();
            }
            catch (NotYetConnectedException ex) {
                ex.printStackTrace();
            }
            catch (NotLoggedInException ex) {
                ex.printStackTrace();
            }
            UsageMeterMain.this.monitorWatchdog();
            UsageMeterMain.this.reloadGraphs(true);
            try {
                Registry registry = UsageMeterMain.this.m_session.getRegistryInstance();
                RegistryRequest request = new RegistryRequest();
                request.addKey(registry.getRegKey(UsageMeterMain.REG_TITLE));
                request.addKey(registry.getRegKey(UsageMeterMain.REG_CURRENT_CONSUMPTION));
                request.addKey(registry.getRegKey(UsageMeterMain.REG_RELOAD_GRAPH));
                request.addKey(registry.getRegKey(UsageMeterMain.REG_VERSION));
                request.addKey(registry.getRegKey(UsageMeterMain.REG_CURRENT_TIME));
                request.addKey(registry.getRegKey(UsageMeterMain.REG_USED_INPUT));
                request.addKey(registry.getRegKey(UsageMeterMain.REG_EXTERNALS));
                UsageMeterMain.this.m_firstDayOfWeek = registry.getRegKey(UsageMeterMain.REG_FIRST_DAY_OF_WEEK);
                request.addKey(UsageMeterMain.this.m_firstDayOfWeek);
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[0] = registry.getRegKey("AppData/Utility/AltTextChannel1");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[1] = registry.getRegKey("AppData/Utility/AltTextChannel2");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[2] = registry.getRegKey("AppData/Utility/AltTextChannel3");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[3] = registry.getRegKey("AppData/Utility/AltTextChannel4");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[4] = registry.getRegKey("AppData/Utility/AltTextChannel5");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[5] = registry.getRegKey("AppData/Utility/AltTextChannel6");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[6] = registry.getRegKey("AppData/Utility/AltTextChannel7");
                ((UsageMeterMain)UsageMeterMain.this).m_altTextReg[7] = registry.getRegKey("AppData/Utility/AltTextChannel8");
                request.addKey(UsageMeterMain.this.m_altTextReg[0]);
                request.addKey(UsageMeterMain.this.m_altTextReg[1]);
                request.addKey(UsageMeterMain.this.m_altTextReg[2]);
                request.addKey(UsageMeterMain.this.m_altTextReg[3]);
                request.addKey(UsageMeterMain.this.m_altTextReg[4]);
                request.addKey(UsageMeterMain.this.m_altTextReg[5]);
                request.addKey(UsageMeterMain.this.m_altTextReg[6]);
                request.addKey(UsageMeterMain.this.m_altTextReg[7]);
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[0] = registry.getRegKey("AppData/Utility/InstTextChannel1");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[1] = registry.getRegKey("AppData/Utility/InstTextChannel2");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[2] = registry.getRegKey("AppData/Utility/InstTextChannel3");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[3] = registry.getRegKey("AppData/Utility/InstTextChannel4");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[4] = registry.getRegKey("AppData/Utility/InstTextChannel5");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[5] = registry.getRegKey("AppData/Utility/InstTextChannel6");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[6] = registry.getRegKey("AppData/Utility/InstTextChannel7");
                ((UsageMeterMain)UsageMeterMain.this).m_instTextReg[7] = registry.getRegKey("AppData/Utility/InstTextChannel8");
                request.addKey(UsageMeterMain.this.m_instTextReg[0]);
                request.addKey(UsageMeterMain.this.m_instTextReg[1]);
                request.addKey(UsageMeterMain.this.m_instTextReg[2]);
                request.addKey(UsageMeterMain.this.m_instTextReg[3]);
                request.addKey(UsageMeterMain.this.m_instTextReg[4]);
                request.addKey(UsageMeterMain.this.m_instTextReg[5]);
                request.addKey(UsageMeterMain.this.m_instTextReg[6]);
                request.addKey(UsageMeterMain.this.m_instTextReg[7]);
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[0] = registry.getRegKey("AppData/Utility/UnitsPerPulse1");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[1] = registry.getRegKey("AppData/Utility/UnitsPerPulse2");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[2] = registry.getRegKey("AppData/Utility/UnitsPerPulse3");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[3] = registry.getRegKey("AppData/Utility/UnitsPerPulse4");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[4] = registry.getRegKey("AppData/Utility/UnitsPerPulse5");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[5] = registry.getRegKey("AppData/Utility/UnitsPerPulse6");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[6] = registry.getRegKey("AppData/Utility/UnitsPerPulse7");
                ((UsageMeterMain)UsageMeterMain.this).m_unitsPerPulseReg[7] = registry.getRegKey("AppData/Utility/UnitsPerPulse8");
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[0]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[1]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[2]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[3]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[4]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[5]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[6]);
                request.addKey(UsageMeterMain.this.m_unitsPerPulseReg[7]);
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[0] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel1");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[1] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel2");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[2] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel3");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[3] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel4");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[4] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel5");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[5] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel6");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[6] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel7");
                ((UsageMeterMain)UsageMeterMain.this).m_unitLabelReg[7] = registry.getRegKey("AppData/Utility/UnitLabelTextChannel8");
                request.addKey(UsageMeterMain.this.m_unitLabelReg[0]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[1]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[2]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[3]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[4]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[5]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[6]);
                request.addKey(UsageMeterMain.this.m_unitLabelReg[7]);
                request.addKey(registry.getRegKey(UsageMeterMain.REG_TOTALIZED_UNITS));
                request.addRegistryListener((RegistryListener)UsageMeterMain.this);
                registry.subscribeRegistry(request, false);
            }
            catch (NotYetConnectedException ex) {
                ex.printStackTrace();
            }
            catch (CommandTimeoutException ex) {
                ex.printStackTrace();
            }
            while (UsageMeterMain.this.loadGraphs) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            CardLayout cl = (CardLayout)UsageMeterMain.this.cardCharts.getLayout();
            cl.show(UsageMeterMain.this.cardCharts, "hourlyChart");
        }

        public void onLoginFailed(EventObject evt, LoginProperties loginProperties) {
            System.out.println(new Date().toString() + " - Login Failed.\n");
            UsageMeterMain.this.promptForLogin();
        }
    }

    class Connection
    implements ConnectionListener {
        Connection() {
        }

        public void onConnectionSuccess(EventObject evt, boolean reconnected) {
            final JniorSession session = (JniorSession)evt.getSource();
            System.out.println(new Date().toString() + " - Connection Successfully Made.\n");
            UsageMeterMain.this.m_rebooting = false;
            try {
                Registry registry = session.getRegistryInstance();
                RegistryKey regkey = registry.getRegKey("Device/AppletDebug", "false");
                regkey.addRegistryListener(new RegistryListener(){

                    public void onRegistryKeyReceived(EventObject evt, RegistryKey regKey) {
                        boolean packets = Boolean2.parseBoolean((String)regKey.getValue());
                        session.setDisplayPackets(packets);
                    }

                    public void onRegistryListReceived(EventObject evt, String parent, String[] nodes) {
                    }
                });
                registry.subscribeRegistry(regkey);
            }
            catch (CommandTimeoutException ex) {
                ex.printStackTrace();
            }
            catch (NotYetConnectedException ex) {
                ex.printStackTrace();
            }
            int anonymousLevel = -1;
            if (session.getDirection() == 0) {
                UsageMeterMain.this.m_details.setStatusText("Retrieving Anonymous Status");
                try {
                    anonymousLevel = UsageMeterMain.this.m_session.getAnonymousStatus();
                }
                catch (CommandTimeoutException ex) {
                    ex.printStackTrace();
                }
                catch (NotYetConnectedException ex) {
                    ex.printStackTrace();
                }
                System.out.println(new Date().toString() + " - Anonymous level is " + anonymousLevel + ".\n");
            }
            if (session.getDirection() == 0) {
                try {
                    if (anonymousLevel >= 0) {
                        UsageMeterMain.this.m_session.login(new LoginProperties("", ""), (LoginListener)UsageMeterMain.this.m_login);
                    } else {
                        try {
                            UsageMeterMain.this.promptForLogin();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (NotYetConnectedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void onConnectionAttempt(EventObject evt, boolean retry) {
            String s = retry ? "Retrying Connection" : "Attempting to connect.";
            System.out.println(new Date().toString() + " - " + s);
            if (!UsageMeterMain.this.m_rebooting) {
                UsageMeterMain.this.m_details.setStatusText(s);
            } else {
                UsageMeterMain.this.m_details.setSubStatusText(s);
            }
        }

        public void onConnectionFailed(EventObject evt) {
            JniorSession js = (JniorSession)evt.getSource();
            ConnectionProperties cp = js.getConnectionProperties();
            String s = "Connection Failed.  " + cp.getRetriesLeft() + " retries remaining";
            System.out.println(new Date().toString() + " - " + s);
            if (!UsageMeterMain.this.m_rebooting) {
                UsageMeterMain.this.m_details.setStatusText(s);
            } else {
                UsageMeterMain.this.m_details.setSubStatusText(s);
            }
        }

        public void onConnectionLost(EventObject evt, boolean reconnect) {
            if (UsageMeterMain.this.m_clientCancel) {
                Container parent = UsageMeterMain.this.getParent();
                if (parent != null) {
                    parent.remove(UsageMeterMain.this);
                }
                UsageMeterMain.this.m_blur.setVisible(false);
            } else {
                if (UsageMeterMain.this.closed) {
                    return;
                }
                String s = "Connection Lost.  " + (reconnect ? "Reconnecting." : "");
                System.out.println(new Date().toString() + " - " + s);
                UsageMeterMain.this.m_blur.setVisible(true);
                if (!UsageMeterMain.this.m_rebooting) {
                    UsageMeterMain.this.m_details.setStatusText(s);
                } else {
                    UsageMeterMain.this.m_details.setSubStatusText(s);
                }
            }
        }

        public void onQueryForPortAttempt(EventObject evt) {
            String s = "Querying the JNIOR for the correct port";
            System.out.println(new Date().toString() + " - " + s);
            if (!UsageMeterMain.this.m_rebooting) {
                UsageMeterMain.this.m_details.setStatusText(s);
            } else {
                UsageMeterMain.this.m_details.setSubStatusText(s);
            }
        }

        public void onQueryForPortSuccess(EventObject evt, int port) {
            String s = "JNIOR Protocol port is port " + port;
            System.out.println(new Date().toString() + " - " + s);
            if (!UsageMeterMain.this.m_rebooting) {
                UsageMeterMain.this.m_details.setStatusText(s);
            } else {
                UsageMeterMain.this.m_details.setSubStatusText(s);
            }
        }
    }
}

