/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.Axis;
import Plot.PlotData;
import Plot.PlotSeries;
import Plot.ViewData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Graph
extends JPanel
implements Runnable,
Printable,
Pageable {
    private static final long SECOND_MILLIS = 1000L;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long HOUR_MILLIS = 3600000L;
    private static final long DAY_MILLIS = 86400000L;
    private Image iDblBuf;
    private ActionListener m_listener;
    private Vector m_title = new Vector();
    private Vector m_subTitle = new Vector();
    private Vector m_plots = new Vector();
    private Axis m_xAxis = new Axis(System.currentTimeMillis(), System.currentTimeMillis(), 1000.0);
    private Axis m_yAxis = null;
    private Axis m_visibleXAxis = null;
    private boolean m_zoomState = false;
    private boolean m_zoomable = false;
    private double m_displayTime = -1.0;
    private double m_initTime = 0.0;
    private double m_latestTime = -1.0;
    private int elements = -1;
    private int chartMax = -1;
    private int chartMin = -1;
    private int maxScale = 25;
    private int minScale = 5;
    public int xGap = 10;
    public int maxBarWidth = 50;
    public int minBarWidth = 1;
    private double m_minimumValuePloted = 2.147483647E9;
    private double m_maximumValuePloted = -2.147483648E9;
    private double m_selectedValue = -2.147483648E9;
    public boolean seriesOffset = true;
    private boolean autoScale = true;
    private Thread thd;
    public boolean started = false;
    private String[] vars;
    public static final int LEFT_MARGIN = 40;
    public static final int TOP_MARGIN = 10;
    public static final int RIGHT_MARGIN = 40;
    public static final int BOTTOM_MARGIN = 50;
    static int count;
    static long runTime;
    private long runSleepTime = 5000L;
    private ViewData vd;
    private boolean running = false;
    private boolean painting = false;
    private static Point currentMousePos;
    private Timer mouseDownTimer = null;
    private Point pt = null;
    private String m_mouseOver = "";
    public static JPopupMenu popupMenu;
    private Rectangle chartArea = null;
    private boolean m_settingYScale = false;
    private boolean m_useCustomYScale = false;
    private double m_customYScaleMin = 0.0;
    private double m_customYScaleMax = 0.0;

    public Graph() {
        this.initComponents();
    }

    public void addTitle(String title) {
        this.m_title.add(title);
    }

    public void addSeries(PlotSeries ps) {
        this.m_plots.addElement(ps);
    }

    public void setXAxis(Axis axis) {
        this.m_xAxis = axis;
        if (this.m_visibleXAxis == null) {
            this.m_visibleXAxis = this.m_xAxis;
        }
        this.m_xAxis.setChartArea(this.chartArea);
    }

    public Axis getXAxis() {
        return this.m_xAxis;
    }

    public double GetMinimumValuePloted() {
        return this.m_minimumValuePloted;
    }

    public double GetMaximumValuePloted() {
        return this.m_maximumValuePloted;
    }

    public double GetSelectedValue() {
        return this.m_selectedValue;
    }

    public void setMouseOver(String s) {
        this.m_mouseOver = s;
    }

    public void setDisplayTime(double end, double display) {
        double start = end - display;
        this.m_displayTime = display;
        this.m_visibleXAxis.setMin(start);
    }

    public void setElements(int elements) {
        this.elements = elements;
    }

    public void setMax(int max) {
        this.chartMax = max;
    }

    public void setMin(int min) {
        this.chartMin = min;
    }

    public void setMaxScale(int max) {
        this.autoScale = false;
        this.maxScale = max;
    }

    public void setMinScale(int min) {
        this.autoScale = false;
        this.minScale = min;
    }

    public Image getThumbnail() {
        return this.iDblBuf;
    }

    public void changeXScale(int minutes) {
        if ((double)(minutes * 60000) > this.m_displayTime) {
            this.m_xAxis.setMin(this.m_initTime);
        }
        this.m_displayTime = (long)minutes * 60000L;
        this.repaint();
    }

    public void setZoomState(boolean b) {
        this.m_zoomState = b;
    }

    public void setListener(ActionListener al) {
        this.m_listener = al;
    }

    public String[] getVars() {
        return this.vars;
    }

    public void setVars(String[] vars) {
        this.vars = (String[])vars.clone();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.painting) {
            return;
        }
        this.painting = true;
        this.iDblBuf = this.createImage(this.getSize().width, this.getSize().height);
        Graphics gDblBuf = this.iDblBuf.getGraphics();
        this.draw(gDblBuf);
        g.drawImage(this.iDblBuf, 0, 0, null);
        if (this.m_listener != null) {
            this.m_listener.actionPerformed(new ActionEvent(this, 0, "Update"));
        }
        this.painting = false;
    }

    public synchronized void draw(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        Date date_time = new Date();
        SimpleDateFormat dFormat = new SimpleDateFormat("HH:mm:ss");
        int fontHeight = fm.getHeight();
        super.paint(g);
        if (this.chartArea == null) {
            this.chartArea = new Rectangle(40, 10, this.getWidth() - 40 - 40, this.getHeight() - 50);
            this.m_xAxis.setChartArea(this.chartArea);
        }
        this.chartArea.y = 15;
        int varNum = 0;
        for (int i = 0; i < this.m_title.size(); ++i) {
            if (i == 0) {
                g.setFont(new Font("Arial", 0, 18));
            } else {
                g.setFont(new Font("Arial", 0, 14));
            }
            String s = this.m_title.elementAt(i).toString();
            if (this.vars != null) {
                while (s.indexOf("var") >= 0 && varNum < this.vars.length) {
                    s = s.replaceFirst("var", this.vars[varNum++]);
                }
            }
            if (s == null || s.equals("")) continue;
            int titleWidth = g.getFontMetrics().stringWidth(s);
            g.drawString(s, this.getWidth() / 2 - titleWidth / 2, this.chartArea.y + fontHeight / 2);
            this.chartArea.y += fm.getHeight() + 5;
        }
        g.setFont(fm.getFont());
        g.setColor(Color.GRAY);
        g.drawRect(40, this.chartArea.y, this.getWidth() - 40 - 40, this.getHeight() - 50 - this.chartArea.y);
        if (this.m_visibleXAxis == null) {
            return;
        }
        if (this.m_visibleXAxis.getRect() == null) {
            this.m_visibleXAxis.setRect(new Rectangle(40, this.getHeight() - 50, this.getWidth() - 40 - 40, 50));
        }
        this.m_visibleXAxis.draw(g);
        this.drawSeries(g);
        if (this.m_settingYScale) {
            g.setColor(new Color(128, 128, 128, 50));
            if (this.pt.y < Graph.currentMousePos.y) {
                g.fillRect(0, this.pt.y, this.getWidth(), Graph.currentMousePos.y - this.pt.y);
            } else {
                g.fillRect(0, Graph.currentMousePos.y, this.getWidth(), this.pt.y - Graph.currentMousePos.y);
            }
        }
    }

    public void start() {
        this.m_visibleXAxis = this.m_xAxis;
        this.m_xAxis.setAutoScale(true);
        this.m_xAxis.setScaleType(0);
        this.m_zoomable = true;
        if (this.m_xAxis.getMin() == -1.0) {
            this.m_initTime = this.m_xAxis.setMin(System.currentTimeMillis());
        }
        this.thd = new Thread((Runnable)this, "Graph Thread");
        this.thd.start();
    }

    public void stop() {
        this.started = false;
        this.running = false;
    }

    public void run() {
        this.started = true;
        this.running = true;
        while (this.running) {
            this.fireTimer();
            try {
                Thread.sleep(this.runSleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void fireTimer() {
        if (this.mouseDownTimer == null) {
            double end = Double.MIN_VALUE;
            double start = Double.MAX_VALUE;
            for (int i = 0; i < this.m_plots.size(); ++i) {
                PlotSeries ps = (PlotSeries)this.m_plots.elementAt(i);
                for (int j = 0; j < ps.size(); ++j) {
                    PlotData pd = (PlotData)ps.elementAt(j);
                    if (pd.getTime() < start) {
                        start = pd.getTime();
                    }
                    if (!(pd.getTime() > end)) continue;
                    end = pd.getTime();
                }
            }
            this.m_latestTime = end;
            if (this.m_xAxis.getMax() <= this.m_visibleXAxis.getMax()) {
                this.m_visibleXAxis.setMax(end);
                this.m_visibleXAxis.setMin(this.m_visibleXAxis.getMax() - this.m_displayTime);
            }
            this.m_xAxis.setMin(start);
            this.m_xAxis.setMax(end);
            this.repaint();
        }
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                Graph.this.formMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                Graph.this.formMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                Graph.this.formMouseReleased(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                Graph.this.formMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                Graph.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new BorderLayout());
    }

    private void formMouseDragged(MouseEvent evt) {
        currentMousePos = evt.getPoint();
        if (this.m_settingYScale) {
            this.repaint();
        }
    }

    private void formMousePressed(MouseEvent evt) {
        currentMousePos = this.pt = evt.getPoint();
        if (this.mouseDownTimer == null && this.m_zoomState && !this.m_settingYScale) {
            this.mouseDownTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    long dx = (long)(Graph.this.pt.getX() - (double)currentMousePos.x) * 250L;
                    if (dx < 0L) {
                        Graph.this.m_visibleXAxis.setMax(Graph.this.m_visibleXAxis.getMax() - (double)Math.abs(dx));
                    } else if (dx > 0L) {
                        if (Graph.this.m_visibleXAxis.getMax() + (double)Math.abs(dx) > Graph.this.m_xAxis.getMax()) {
                            Graph.this.m_visibleXAxis.setMax(Graph.this.m_xAxis.getMax());
                        } else {
                            Graph.this.m_visibleXAxis.setMax(Graph.this.m_visibleXAxis.getMax() + (double)Math.abs(dx));
                        }
                    } else {
                        return;
                    }
                    Graph.this.m_zoomState = false;
                    Graph.this.setDisplayTime(Graph.this.m_visibleXAxis.getMax(), Graph.this.m_displayTime);
                    Graph.this.m_zoomState = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Graph.this.repaint();
                        }
                    });
                }
            });
            this.mouseDownTimer.start();
        }
    }

    private void formMouseReleased(MouseEvent evt) {
        if (this.mouseDownTimer != null) {
            this.mouseDownTimer.stop();
            this.mouseDownTimer = null;
        }
        if (!evt.isPopupTrigger()) {
            if (this.m_settingYScale) {
                PlotSeries[] ps = new PlotSeries[this.m_plots.size()];
                double min = this.getMin(ps);
                double max = this.getMax(ps);
                int scaleFactor = this.getScaleFactor(ps, min, max);
                if (this.pt.y < Graph.currentMousePos.y) {
                    this.m_customYScaleMin = this.getYAxisValueAt(currentMousePos.getLocation());
                    this.m_customYScaleMin -= this.m_customYScaleMin % (double)scaleFactor;
                    this.m_customYScaleMax = this.getYAxisValueAt(this.pt.getLocation());
                    this.m_customYScaleMax = this.m_customYScaleMax - this.m_customYScaleMax % (double)scaleFactor + (double)scaleFactor;
                } else {
                    this.m_customYScaleMin = this.getYAxisValueAt(this.pt.getLocation());
                    this.m_customYScaleMin -= this.m_customYScaleMin % (double)scaleFactor;
                    this.m_customYScaleMax = this.getYAxisValueAt(currentMousePos.getLocation());
                    this.m_customYScaleMax = this.m_customYScaleMax - this.m_customYScaleMax % (double)scaleFactor + (double)scaleFactor;
                }
                this.m_useCustomYScale = true;
                this.m_settingYScale = false;
                this.repaint();
            }
            return;
        }
        final Object source = evt.getSource();
        if (popupMenu.getComponentCount() > 0) {
            popupMenu.removeAll();
        }
        JMenuItem menuZoomFactor1 = new JMenuItem("1 Hour");
        JMenuItem menuZoomFactor2 = new JMenuItem("2 Hours");
        JMenuItem menuZoomFactor4 = new JMenuItem("4 Hours");
        JMenuItem menuZoomFactor8 = new JMenuItem("8 Hours");
        JMenuItem menuZoomFactorAll = new JMenuItem("Show All");
        JMenuItem menuSetYScale = new JMenuItem("Set Custom Y Scale");
        JMenuItem menuClearYScale = new JMenuItem("Clear Custom Y Scale");
        JMenuItem menuPrint = new JMenuItem("Print Current Chart");
        JMenuItem menuPrintAll = new JMenuItem("Print All Charts");
        menuZoomFactor1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_zoomState = false;
                Graph.this.m_visibleXAxis = (Axis)Graph.this.m_xAxis.clone();
                Graph.this.setDisplayTime(Graph.this.m_visibleXAxis.getMax(), 3600000.0);
                Graph.this.m_zoomState = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graph.this.repaint();
                    }
                });
            }
        });
        menuZoomFactor2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_zoomState = false;
                Graph.this.m_visibleXAxis = (Axis)Graph.this.m_xAxis.clone();
                Graph.this.setDisplayTime(Graph.this.m_visibleXAxis.getMax(), 7200000.0);
                Graph.this.m_zoomState = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graph.this.repaint();
                    }
                });
            }
        });
        menuZoomFactor4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_zoomState = false;
                Graph.this.m_visibleXAxis = (Axis)Graph.this.m_xAxis.clone();
                Graph.this.setDisplayTime(Graph.this.m_visibleXAxis.getMax(), 1.44E7);
                Graph.this.m_zoomState = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graph.this.repaint();
                    }
                });
            }
        });
        menuZoomFactor8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_zoomState = false;
                Graph.this.m_visibleXAxis = (Axis)Graph.this.m_xAxis.clone();
                Graph.this.setDisplayTime(Graph.this.m_visibleXAxis.getMax(), 2.88E7);
                Graph.this.m_zoomState = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graph.this.repaint();
                    }
                });
            }
        });
        menuZoomFactorAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_zoomState = false;
                Graph.this.m_visibleXAxis = Graph.this.m_xAxis;
                Graph.this.fireTimer();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graph.this.repaint();
                    }
                });
            }
        });
        menuSetYScale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_settingYScale = true;
            }
        });
        menuClearYScale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph.this.m_useCustomYScale = false;
                Graph.this.repaint();
            }
        });
        menuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Graph.this.m_listener != null) {
                    Graph.this.m_listener.actionPerformed(new ActionEvent(source, 0, "Print Current"));
                }
            }
        });
        menuPrintAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Graph.this.m_listener != null) {
                    Graph.this.m_listener.actionPerformed(new ActionEvent(source, 0, "Print All"));
                }
            }
        });
        if (this.m_zoomable) {
            popupMenu.add(menuZoomFactor1);
            popupMenu.add(menuZoomFactor2);
            popupMenu.add(menuZoomFactor4);
            popupMenu.add(menuZoomFactor8);
            popupMenu.add(menuZoomFactorAll);
            popupMenu.addSeparator();
        }
        popupMenu.add(menuSetYScale);
        popupMenu.add(menuClearYScale);
        popupMenu.addSeparator();
        popupMenu.add(menuPrint);
        popupMenu.add(menuPrintAll);
        popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void formMouseMoved(MouseEvent evt) {
        int x = evt.getX();
        PlotData closestPlotDataPoint = null;
        this.m_selectedValue = 0.0;
        double closestPlotDataDeltaX = 2.147483647E9;
        if (this.mouseDownTimer == null) {
            for (int i = 0; i < this.m_plots.size(); ++i) {
                PlotSeries ps = (PlotSeries)this.m_plots.elementAt(i);
                for (int j = 0; j < ps.size(); ++j) {
                    PlotData pd = (PlotData)ps.elementAt(j);
                    double xPD = pd.getX();
                    if (Math.abs((double)x - xPD) < closestPlotDataDeltaX) {
                        closestPlotDataDeltaX = Math.abs((double)x - xPD);
                        closestPlotDataPoint = pd;
                    }
                    if (pd.owner.type == 1 || !pd.isOver(evt.getX(), evt.getY()) || this.m_mouseOver == null || this.m_mouseOver.equals("")) continue;
                    int pos = this.m_mouseOver.indexOf("</html>");
                    String s = this.m_mouseOver.substring(0, pos) + pd.toString() + "</html>";
                    this.setToolTipText(s);
                    return;
                }
                if (ps.type != 1 || closestPlotDataPoint == null) continue;
                if (closestPlotDataPoint.setHighlighted()) {
                    this.repaint();
                }
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                nf.setMinimumFractionDigits(2);
                this.m_selectedValue = closestPlotDataPoint.getDouble();
                String s = "<html>" + new Date((long)closestPlotDataPoint.getTime()).toString() + " : " + nf.format(closestPlotDataPoint.getDouble()) + "</html>";
                this.setToolTipText(s);
                return;
            }
            if (this.m_mouseOver != null && !this.m_mouseOver.equals("")) {
                this.setToolTipText(this.m_mouseOver);
            }
        }
    }

    private void formMouseExited(MouseEvent evt) {
        int plotsSize = this.m_plots.size();
        for (int i = 0; i < plotsSize; ++i) {
            PlotSeries ps = (PlotSeries)this.m_plots.get(i);
            ps.clearHighlighted();
        }
        this.repaint();
    }

    public void doPrint() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pf = pjob.defaultPage();
        pjob.setPrintable(this, pf);
        pjob.setPageable(this);
        try {
            if (pjob.printDialog()) {
                pjob.print();
            }
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    private int getScaleFactor(PlotSeries[] ps, double min, double max) {
        int sf = (int)((max - min) / 2.0) * 2;
        if (sf < this.minScale) {
            sf = this.minScale;
        } else if (sf > this.maxScale) {
            sf = this.maxScale;
        }
        return sf;
    }

    private double getMin(PlotSeries[] ps) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            ps[i] = (PlotSeries)this.m_plots.elementAt(i);
            min = ps[i].getMin(this.m_visibleXAxis.getMin(), this.m_visibleXAxis.getMax());
        }
        return min;
    }

    private double getMax(PlotSeries[] ps) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            ps[i] = (PlotSeries)this.m_plots.elementAt(i);
            max = ps[i].getMax(this.m_visibleXAxis.getMin(), this.m_visibleXAxis.getMax());
        }
        return max;
    }

    private void drawYaxisLabels(Graphics g, double min, double max, int scaleFactor, PlotSeries[] ps) {
        double pixelsPerY = (double)(this.getHeight() - 50 - this.chartArea.y) / (max - min);
        for (int j = 0; j < this.m_plots.size(); ++j) {
            FontMetrics fm = g.getFontMetrics();
            int fy = fm.getHeight();
            g.setColor(Color.BLACK);
            block5: for (int i = (int)min; i <= (int)max; i += scaleFactor) {
                int y1 = (int)((double)this.getHeight() - (((double)i - min) * pixelsPerY + 50.0));
                if (i % scaleFactor == 0 && (double)i != min && (double)i != max) {
                    g.setColor(Color.lightGray);
                    g.drawLine(40, y1, this.getWidth() - 40, y1);
                    g.setColor(Color.black);
                }
                switch (ps[j].yLabelSide) {
                    case 1: {
                        if (i % scaleFactor == 0) {
                            g.drawString(String.valueOf(i), this.getWidth() - 40 + 5, y1 + fy / 3);
                            continue block5;
                        }
                        g.drawLine(this.getWidth() - 40, y1, this.getWidth() - 40 + 10, y1);
                        continue block5;
                    }
                    case 0: {
                        if (i % scaleFactor == 0) {
                            g.drawString(String.valueOf(i), 5, y1 + fy / 3);
                            continue block5;
                        }
                        g.drawLine(40, y1, 30, y1);
                    }
                }
            }
        }
    }

    private double getYAxisValueAt(Point p) {
        double value = 100.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        PlotSeries[] ps = new PlotSeries[this.m_plots.size()];
        min = this.getMin(ps);
        max = this.getMax(ps);
        if (this.m_useCustomYScale) {
            min = this.m_customYScaleMin;
            max = this.m_customYScaleMax;
        }
        int scaleFactor = this.getScaleFactor(ps, min, max);
        min -= Math.abs(min) % (double)scaleFactor;
        max = max - Math.abs(max) % (double)scaleFactor + (double)scaleFactor;
        if (this.chartMax >= 0) {
            max = this.chartMax;
        }
        if (this.chartMin >= 0) {
            min = this.chartMin;
        }
        if (this.m_useCustomYScale) {
            min = this.m_customYScaleMin;
            max = this.m_customYScaleMax;
        }
        for (int i = 0; i < ps.length; ++i) {
            if (ps[i] == null) continue;
            scaleFactor = ps[i].getFactor();
        }
        double pixelsPerY = (double)(this.getHeight() - 50 - this.chartArea.y) / (max - min);
        double chartHeight = this.getHeight() - 50 - this.chartArea.y;
        double percentY = (chartHeight - (double)(p.y - this.chartArea.y)) / chartHeight;
        value = (max - min) * percentY + min;
        int x = this.chartArea.x;
        return value;
    }

    private void drawSeries(Graphics g) {
        double viewTime;
        int y1 = 0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int chartWidth = this.getWidth() - 80;
        int chartHeight = this.getHeight() - 40;
        int totalChartTime = (int)(this.m_visibleXAxis.getMax() - this.m_visibleXAxis.getMin());
        viewTime = totalChartTime > 240000 ? (viewTime = this.m_visibleXAxis.getMax() - 240000.0) : this.m_visibleXAxis.getMin();
        PlotSeries[] ps = new PlotSeries[this.m_plots.size()];
        min = this.getMin(ps);
        max = this.getMax(ps);
        if (this.m_useCustomYScale) {
            min = this.m_customYScaleMin;
            max = this.m_customYScaleMax;
        }
        int scaleFactor = this.getScaleFactor(ps, min, max);
        min -= Math.abs(min) % (double)scaleFactor;
        max = max - Math.abs(max) % (double)scaleFactor + (double)scaleFactor;
        if (this.chartMax >= 0) {
            max = this.chartMax;
        }
        if (this.chartMin >= 0) {
            min = this.chartMin;
        }
        if (this.m_useCustomYScale) {
            min = this.m_customYScaleMin;
            max = this.m_customYScaleMax;
        }
        if (min % (double)scaleFactor != 0.0) {
            min -= min % (double)scaleFactor;
        }
        if (max % (double)scaleFactor != 0.0) {
            max += (double)scaleFactor - max % (double)scaleFactor;
        }
        double pixelsPerY = (double)(this.getHeight() - 50 - this.chartArea.y) / (max - min);
        this.drawYaxisLabels(g, min, max, scaleFactor, ps);
        double viewMin = this.m_visibleXAxis.getMin();
        double viewMax = this.m_visibleXAxis.getAdjustedMax();
        this.m_minimumValuePloted = 2.147483647E9;
        this.m_maximumValuePloted = -2.147483648E9;
        int plotsSize = this.m_plots.size();
        block4: for (int i = 0; i < plotsSize; ++i) {
            int dx;
            int ellapsed;
            PlotData prev_pd = null;
            int prev_dx = 0;
            boolean time_shown_dx = false;
            if (ps[i].size() == 0) continue;
            int numberOfXItems = this.elements < 0 ? ps[i].size() : this.elements;
            double pixelsPerX = chartWidth / numberOfXItems;
            int itemWidth = chartWidth / (this.elements < 0 ? ps[i].size() : this.elements * this.m_plots.size()) - 1 * this.xGap % 1;
            int width = chartWidth / (this.elements < 0 ? ps[i].size() : this.elements * this.m_plots.size()) - this.xGap;
            if (width > this.maxBarWidth) {
                width = this.maxBarWidth;
            }
            if (width < this.minBarWidth) {
                width = this.minBarWidth;
            }
            g.setColor(ps[i].color);
            int psSize = ps[i].size();
            double lastTime = 0.0;
            ps[i].xAxis = this.m_visibleXAxis;
            for (int j = 0; j < psSize; ++j) {
                PlotData pd = (PlotData)ps[i].get(j);
                double time = pd.getTime();
                double relativeTime = pd.getRelativeTime();
                if (pd.getDouble() > this.m_maximumValuePloted) {
                    this.m_maximumValuePloted = pd.getDouble();
                }
                if (pd.getDouble() < this.m_minimumValuePloted) {
                    this.m_minimumValuePloted = pd.getDouble();
                }
                if (this.m_zoomState && relativeTime < viewMax - this.m_displayTime) {
                    pd.invalidate();
                    continue;
                }
                if (relativeTime > viewMax) continue;
                lastTime = time;
                ellapsed = (int)(time - viewMin);
                dx = (int)((double)ellapsed / (viewMax - viewMin) * (double)chartWidth + (double)(width * i));
                double totalTime = viewMax - viewMin;
                dx = pd.calculateX(viewMin, totalTime, pixelsPerX, chartWidth) + 40 + width * i;
                if (relativeTime >= viewMin) {
                    if (prev_pd != null) {
                        y1 = (int)((double)this.getHeight() - (((prev_pd.getDouble() < max ? prev_pd.getDouble() : max) - min) * pixelsPerY + 50.0));
                    }
                    int y2 = (int)((double)this.getHeight() - (((pd.getDouble() < max ? pd.getDouble() : max) - min) * pixelsPerY + 50.0));
                    int itemOffset = width / 2;
                    pd.draw(g, 40, this.getHeight() - 50, itemOffset, chartWidth, this.getHeight() - 50 - this.chartArea.y, pixelsPerX, pixelsPerY, this.seriesOffset ? width * i : 0, this.m_visibleXAxis.getMin(), totalTime, (int)min, width, prev_pd);
                } else {
                    System.out.println("BAD DATA - Time " + new Date((long)time) + " Relative Time " + new Date((long)relativeTime));
                }
                prev_pd = pd;
                prev_dx = dx < 0 ? 0 : dx;
            }
            if (prev_pd == null || psSize <= 1) continue;
            ellapsed = (int)((double)System.currentTimeMillis() - this.m_visibleXAxis.getMin());
            dx = (int)((double)ellapsed / (this.m_visibleXAxis.getMax() - this.m_visibleXAxis.getMin()) * (double)(this.getWidth() - 40 - 40));
            y1 = (int)((double)this.getHeight() - (((prev_pd.getDouble() < max ? prev_pd.getDouble() : max) - min) * pixelsPerY + 50.0));
            switch (ps[i].type) {
                case 3: {
                    continue block4;
                }
                case 0: {
                    g.drawLine(prev_dx + 40, y1, dx + 40, y1);
                }
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int param) throws PrinterException {
        Graphics2D g2d = (Graphics2D)graphics;
        double scale = 1.0;
        if (pageFormat.getImageableWidth() < (double)this.getWidth()) {
            scale = pageFormat.getImageableWidth() / (double)this.getWidth();
        } else if (pageFormat.getImageableWidth() < (double)this.getWidth()) {
            scale = pageFormat.getImageableHeight() / (double)this.getHeight();
        }
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2d.scale(scale, scale);
        this.draw(g2d);
        return 0;
    }

    public int getNumberOfPages() {
        return 1;
    }

    public PageFormat getPageFormat(int param) throws IndexOutOfBoundsException {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        return pjob.defaultPage();
    }

    public Printable getPrintable(int param) throws IndexOutOfBoundsException {
        return this;
    }

    public int Max() {
        return this.chartMax;
    }

    static {
        popupMenu = new JPopupMenu();
    }
}

