/*
 * Decompiled with CFR 0.152.
 */
import Plot.PlotData;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class EntryAdapter
extends PlotData {
    private Entry entry;
    private int timePeriod;
    private static final String[] daysOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    public static String m_unitLabel = "";

    public EntryAdapter(Entry entry, int inputNumber, int timePeriod) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(UsageMeterMain.currentJniorDate.getTime());
        this.entry = (Entry)entry.clone();
        this.timePeriod = timePeriod;
        if (timePeriod == 10) {
            cal.setTimeInMillis(entry.time - 3600000L);
        } else {
            cal.setTimeInMillis(entry.time);
        }
        this.time = cal.get(timePeriod);
        if (timePeriod == 7) {
            this.time -= 1.0;
        }
        long millis = EntryAdapter.getMillisFromPeriod(timePeriod);
        this.data = new Double(entry.m_counts[inputNumber - 1]);
    }

    public String getTimeString() {
        if (this.entry != null) {
            Date d = new Date(this.entry.time);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, MMM dd yyyy");
            int t = cal.get(this.timePeriod);
            switch (this.timePeriod) {
                case 11: {
                    return "Hour " + t + "00";
                }
                case 7: {
                    return sdf.format(d);
                }
                case 5: {
                    return sdf.format(d);
                }
                case 3: {
                    return "Week " + t;
                }
            }
            return d.toString();
        }
        return super.getTimeString();
    }

    public String getDoubleString() {
        String s = String.valueOf(this.data);
        switch (this.timePeriod) {
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                s = s + " " + m_unitLabel;
            }
        }
        return s;
    }

    public static long getMillisFromPeriod(int timePeriod) {
        long millis = 0L;
        switch (timePeriod) {
            case 12: {
                millis = 60000L;
                break;
            }
            case 11: {
                millis = 3600000L;
                break;
            }
            case 5: 
            case 7: {
                millis = 86400000L;
                break;
            }
            case 3: {
                millis = 604800000L;
            }
        }
        return millis;
    }
}

