/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

class Entry
implements Cloneable,
Comparable {
    public static final int TIME_PART = 0;
    public static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    public static final long WEEK_MILLIS = 604800000L;
    public static final long MONTH_MILLIS = 2678400000L;
    public static final long YEAR_MILLIS = 31449600000L;
    public long time;
    public double[] m_counts = new double[8];
    public static double m_unitsPerPulse = 1.0;
    String line = null;
    byte[] lineBytes = null;
    String dateString;
    int dateStringLen;
    int addTo;

    Entry() {
    }

    public void copyFrom(Entry entry) {
        this.time = entry.time;
        for (int i = 0; i < 8; ++i) {
            this.m_counts[i] = entry.m_counts[i];
        }
    }

    public void copy(Entry entry) {
        entry.time = this.time;
        for (int i = 0; i < 8; ++i) {
            entry.m_counts[i] = this.m_counts[i];
        }
    }

    public Object clone() {
        Entry entry = new Entry();
        entry.time = this.time;
        for (int i = 0; i < 8; ++i) {
            entry.m_counts[i] = this.m_counts[i];
        }
        return entry;
    }

    private static long getLong(byte[] b, int offset) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = (l << 8) + (long)(b[offset++] & 0xFF);
        }
        return l;
    }

    private static int getInt(byte[] b, int offset) {
        int l = 0;
        for (int i = 0; i < 4; ++i) {
            l = (l << 8) + (b[offset++] & 0xFF);
        }
        return l;
    }

    private static int getShort(byte[] b, int offset) {
        int l = 0;
        for (int i = 0; i < 2; ++i) {
            l = (l << 8) + (b[offset++] & 0xFF);
        }
        return l;
    }

    public static Entry getEntryFromBytes(byte[] line) {
        Entry newEntry = new Entry();
        try {
            newEntry.time = Entry.getLong(line, 2);
            for (int i = 0; i < 8; ++i) {
                newEntry.m_counts[i] = Entry.getShort(line, i * 2 + 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            newEntry = null;
        }
        return newEntry;
    }

    public static Entry getEntryFromLine(String line) {
        Entry newEntry = new Entry();
        String[] parts = line.split(",");
        if (parts.length < 3) {
            return null;
        }
        try {
            newEntry.time = Long.parseLong(parts[0]);
            for (int i = 0; i < 8; ++i) {
                newEntry.m_counts[i] = (double)Integer.parseInt(parts[i + 1].trim()) * m_unitsPerPulse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            newEntry = null;
        }
        return newEntry;
    }

    public void setTime(long t) {
        this.time = t;
        this.dateString = null;
        this.setDateString();
    }

    public long getTime() {
        return this.time;
    }

    private void setDateString() {
        if (this.dateString == null) {
            this.dateString = new Date(this.time).toString();
            this.dateStringLen = this.dateString.length();
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean b) {
        if (b) {
            this.dateString = null;
            this.line = null;
        }
        this.setDateString();
        if (this.line == null) {
            this.line = this.time + ",";
        }
        for (int i = 0; i < 8; ++i) {
            this.line = this.line + this.m_counts[i] + ",";
        }
        this.line = this.line + this.dateString;
        return this.line;
    }

    public int compareTo(Object obj) {
        try {
            if (this.time < ((Entry)obj).time) {
                return -1;
            }
            if (this.time == ((Entry)obj).time) {
                return 0;
            }
            return 1;
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

