/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.lexer;

import com.integ.tasker.lexer.TokenType;

public class Token {
    public final int type;
    public String content;
    public int lineNo;
    public int colPos;

    public Token(int t, String c, int lineNo, int colPos) {
        this.type = t;
        this.content = c;
        this.lineNo = lineNo;
        this.colPos = colPos;
    }

    public String toString() {
        if (this.type == 4) {
            return "STRING ( " + this.content + " ) " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 0) {
            return "IDENTIFIER ( " + this.content + " ) " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 1) {
            return "PUNCTUATOR ( " + this.content + " ) " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 3) {
            return "NUMERIC ( " + this.content + " ) " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 16) {
            return "LITERAL ( " + this.content + " ) " + this.lineNo + ":" + this.colPos;
        }
        return this.type + " ( " + this.content + " ) " + this.lineNo + " " + this.colPos;
    }

    public boolean checkContent(String expected) {
        return this.content.equals(expected);
    }

    public boolean checkType(int expectedType) {
        return expectedType == this.type;
    }

    public String getContent() {
        return this.content;
    }

    public boolean checkType(TokenType ... tokenTypeArray) {
        int tokenTypeArrayArrayLength = tokenTypeArray.length;
        for (int i = 0; i < tokenTypeArrayArrayLength; ++i) {
            if (!this.checkType(tokenTypeArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean checkContent(String ... expectedContentArray) {
        int expectedContentArrayLength = expectedContentArray.length;
        for (int i = 0; i < expectedContentArrayLength; ++i) {
            if (!this.checkContent(expectedContentArray[i])) continue;
            return true;
        }
        return false;
    }
}

