/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.Unloadable;
import com.integ.tasker.tasks.Scope;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.Json;

public class ExpressionEvaluationTrigger
extends Trigger
implements Unloadable {
    private final Json _paramsJson;
    private final String _expression;
    private boolean _initialEvaluation = true;
    private boolean _lastResult = false;

    public ExpressionEvaluationTrigger(Json triggerJson) {
        this._paramsJson = (Json)triggerJson.get("Params");
        this._expression = this._paramsJson.getString("Value");
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
    }

    @Override
    public void checkForTrigger() throws Throwable {
        if (super.isTriggered()) {
            return;
        }
        Scope scope = new Scope();
        ExpressionEngine _expressionEngine = new ExpressionEngine();
        _expressionEngine.parse(this._expression);
        Object resultObject = _expressionEngine.execute(scope);
        if (null != resultObject) {
            boolean result = (Boolean)resultObject;
            if (this._initialEvaluation) {
                this._lastResult = result;
                this._initialEvaluation = false;
            }
            if (result) {
                this.trigger();
            }
            this._lastResult = result;
        }
    }

    @Override
    public void unload() {
    }
}

