/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.tasker.tasks.Scope;
import java.text.DecimalFormat;

public class StringObject
extends AbstractObjectCall {
    private static final DecimalFormat DEFAULT = new DecimalFormat("0.00");

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            parser.nextToken();
            parser.expect(".");
            if (!parser.currentToken().checkType(0)) {
                throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
            }
            switch (this._fieldOrMethodName = parser.eatToken().content) {
                case "formatdecimal": {
                    this.parseArguments(parser);
                    break;
                }
                case "frombytes": {
                    this.parseArguments(parser);
                    break;
                }
                case "equals": {
                    this.parseArguments(parser);
                    break;
                }
                case "startswith": {
                    this.parseArguments(parser);
                    break;
                }
                default: {
                    throw new ScriptParserException(String.format("unknown field or method: %s", this._fieldOrMethodName));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ScriptParserException("unable to process StringObject", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        System.out.println(this._fieldOrMethodName);
        switch (this._fieldOrMethodName) {
            case "formatdecimal": {
                double number = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                DecimalFormat decimalFormat = DEFAULT;
                if (2 <= this._arguments.size()) {
                    String formatString = ((AbstractNode)this._arguments.get(1)).toString();
                    decimalFormat = new DecimalFormat(formatString);
                }
                return decimalFormat.format(number);
            }
            case "frombytes": {
                try {
                    System.out.println("_arguments.get(0) = " + this._arguments.get(0));
                    ReferenceObject referenceObject = (ReferenceObject)this._arguments.get(0);
                    byte[] bytes = (byte[])referenceObject.execute(scope);
                    return new String(bytes);
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException(String.format("string.frombytes expected a ReferenceObject but got %s", ((AbstractNode)this._arguments.get(0)).getClass().getName()));
                }
            }
            case "equals": {
                System.out.println("_arguments.size() = " + this._arguments.size());
                String arg1 = ((AbstractNode)this._arguments.get(0)).toString();
                System.out.println("arg1 = " + arg1 + " " + arg1.length());
                if (this._arguments.get(0) instanceof ReferenceObject) {
                    arg1 = (String)((ReferenceObject)this._arguments.get(0)).execute(scope);
                    System.out.println("arg1 = " + arg1 + " " + arg1.length());
                }
                String arg2 = ((AbstractNode)this._arguments.get(1)).toString();
                System.out.println("arg2 = " + arg2 + " " + arg2.length());
                if (this._arguments.get(1) instanceof ReferenceObject) {
                    arg2 = (String)((ReferenceObject)this._arguments.get(1)).execute(scope);
                    System.out.println("arg2 = " + arg2 + " " + arg2.length());
                }
                System.out.println("arg1.equals(arg2) = " + arg1.equals(arg2));
                return arg1.equals(arg2);
            }
            case "startswith": {
                System.out.println("_arguments.size() = " + this._arguments.size());
                String arg1 = ((AbstractNode)this._arguments.get(0)).toString();
                System.out.println("arg1 = " + arg1 + " " + arg1.length());
                if (this._arguments.get(0) instanceof ReferenceObject) {
                    arg1 = (String)((ReferenceObject)this._arguments.get(0)).execute(scope);
                    System.out.println("arg1 = " + arg1 + " " + arg1.length());
                }
                String arg2 = ((AbstractNode)this._arguments.get(1)).toString();
                System.out.println("arg2 = " + arg2 + " " + arg2.length());
                if (this._arguments.get(1) instanceof ReferenceObject) {
                    arg2 = (String)((ReferenceObject)this._arguments.get(1)).execute(scope);
                    System.out.println("arg2 = " + arg2 + " " + arg2.length());
                }
                System.out.println("arg1.startsWith(arg2) = " + arg1.startsWith(arg2));
                return arg1.startsWith(arg2);
            }
        }
        return null;
    }
}

