/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;

public class MathObject
extends AbstractObjectCall {
    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (parser.shouldDebug()) {
                System.out.println("MathObject parser.currentToken() = " + parser.currentToken());
            }
            parser.nextToken();
            if (parser.currentToken().checkType(46)) {
                parser.nextToken();
                if (!parser.currentToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
                }
                this._fieldOrMethodName = parser.eatToken().content;
                System.out.println("_fieldOrMethodName = " + this._fieldOrMethodName);
                switch (this._fieldOrMethodName) {
                    case "abs": 
                    case "pow": 
                    case "round": 
                    case "floor": 
                    case "ceil": 
                    case "min": 
                    case "max": 
                    case "sqrt": 
                    case "random": {
                        this.parseArguments(parser);
                    }
                }
            } else {
                this.parseArguments(parser);
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process math object", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        System.out.println("_fieldOrMethodName = " + this._fieldOrMethodName);
        if ("abs".equalsIgnoreCase(this._fieldOrMethodName)) {
            if (1 == this._arguments.size()) {
                Object arg1 = ((AbstractNode)this._arguments.get(0)).execute(scope);
                double number1 = (Double)arg1;
                return Math.abs(number1);
            }
        } else {
            if ("pow".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (2 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    double number2 = Double.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                    return Math.pow(number1, number2);
                }
                throw new RuntimeException("math.pow missing argument");
            }
            if ("sqrt".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (1 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    return Math.sqrt(number1);
                }
            } else if ("round".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (1 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    return Math.round(number1);
                }
            } else if ("floor".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (1 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    return Math.floor(number1);
                }
            } else if ("ceil".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (1 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    return Math.ceil(number1);
                }
            } else if ("min".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (2 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    double number2 = Double.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                    return Math.min(number1, number2);
                }
            } else if ("max".equalsIgnoreCase(this._fieldOrMethodName)) {
                if (2 == this._arguments.size()) {
                    double number1 = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                    double number2 = Double.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                    return Math.max(number1, number2);
                }
            } else if ("random".equalsIgnoreCase(this._fieldOrMethodName)) {
                Number lowerBound = 0;
                Number upperBound = 1;
                if (0 != this._arguments.size()) {
                    if (1 == this._arguments.size()) {
                        System.out.println("_arguments.get(0) = " + this._arguments.get(0) + " " + ((AbstractNode)this._arguments.get(0)).getClass());
                        upperBound = (Number)((ValueNode)this._arguments.get(0)).getValue();
                    } else if (2 == this._arguments.size()) {
                        lowerBound = (Number)((ValueNode)this._arguments.get(0)).getValue();
                        upperBound = (Number)((ValueNode)this._arguments.get(1)).getValue();
                    }
                } else {
                    return Math.random();
                }
                if (lowerBound instanceof Integer && upperBound instanceof Integer) {
                    return (int)((double)lowerBound.intValue() + Math.random() * (double)(upperBound - lowerBound.intValue()));
                }
                return lowerBound.doubleValue() + Math.random() * (((Number)upperBound).doubleValue() - lowerBound.doubleValue());
            }
        }
        return null;
    }
}

