/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.tasker.AssemblyInfo;
import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.ScheduleCollection;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.AssemblyInfoBase;
import java.util.Json;

public class ScheduleConfiguration {
    private static final Logger LOG;
    private final WorkspaceFile _workspaceConfigurationFile;
    private final TaskCollection _taskCollection = new TaskCollection();

    public ScheduleConfiguration(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public void loadConfiguration(Json[] scheduleListJsonArray) throws Throwable {
        ScheduleCollection.clearForWorkspace(this._workspaceConfigurationFile);
        if (null == scheduleListJsonArray || 0 == scheduleListJsonArray.length) {
            return;
        }
        for (Json scheduleJson : scheduleListJsonArray) {
            LOG.info("scheduleJson: " + scheduleJson);
        }
        for (Json scheduleJson : scheduleListJsonArray) {
            Schedule schedule = new Schedule(scheduleJson, this._workspaceConfigurationFile);
            if (!schedule.isEnabled()) continue;
            ScheduleCollection.put(schedule);
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        AssemblyInfo.getInstance();
        LOG = Logger.getLogger(stringBuilder.append(AssemblyInfoBase.getName()).append("_schedules.log").toString());
    }
}

