function parseLoggerAction(json) {
    var method = json.Method;

    switch (method) {
        case 'LogEntry':
            return new LogEntry();

        case 'LogProfile':
            return new LogProfile();

        default:
            throw new Error('Unknown Logger Method: ' + JSON.stringify(json, null, 2));
    }
}



class LoggerAction extends Action {
    constructor() {
        super();
        this.Type = 'Logger';
        this.Method = 'void';
        this.Params = {};
    }
}



class LogEntry extends LoggerAction {
    constructor(filename, text) {
        super();
        this.Method = 'LogEntry';
        this.Params.Filename = filename;
        this.Params.Text = text;
    }

    editTemplate() {
        var template = '<div style="display:inline-grid" class="form-inline">' +
            '<div class="form-group" style="margin-bottom:4px;">Log <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Text" data-toggle="tooltip" title="Text to be logged" style="width:600px;"></div>' +
            '<div class="form-group">to <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.FileName" data-toggle="tooltip" title="Filename" style="width:600px;"></div>' +
            '</div>';
        return template;
    }
}



class LogProfile extends LoggerAction {
    constructor(profileName) {
        super();
        this.Method = 'LogProfile';
        this.Params.ProfileName = profileName;
    }

    editTemplate() {
        var template = 'Force Log Profile entry for <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.ProfileName" data-toggle="tooltip" title="The name of the Log Profile to force an entry to be made">';
        return template;
    }
}