/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;

public class ArrayUtilsObject
extends AbstractObjectCall {
    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            parser.setDebug(true);
            parser.nextToken();
            parser.expect(".");
            if (!parser.currentToken().checkType(0)) {
                throw new UnexpectedTokenException("METHOD NAME", parser.currentToken());
            }
            this._fieldOrMethodName = parser.eatToken().content;
            this.parseArguments(parser);
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process ArrayUtils", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        switch (this._fieldOrMethodName) {
            case "getshort": {
                ReferenceObject referenceObject = (ReferenceObject)this._arguments.get(0);
                byte[] bytes = (byte[])referenceObject.execute(scope);
                int pos = Integer.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                boolean shouldSwap = false;
                if (3 <= this._arguments.size()) {
                    shouldSwap = Boolean.valueOf(((AbstractNode)this._arguments.get(2)).execute(scope).toString());
                    System.out.println("shouldSwap = " + shouldSwap);
                }
                short i = ArrayUtils.getShort((byte[])bytes, (int)pos);
                if (shouldSwap) {
                    i = ArrayUtils.swapEndian((short)i);
                }
                return i;
            }
            case "getint": {
                ReferenceObject referenceObject = (ReferenceObject)this._arguments.get(0);
                byte[] bytes = (byte[])referenceObject.execute(scope);
                int pos = Integer.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                boolean shouldSwap = false;
                if (3 <= this._arguments.size()) {
                    shouldSwap = Boolean.valueOf(((AbstractNode)this._arguments.get(2)).execute(scope).toString());
                }
                int s = ArrayUtils.getInt((byte[])bytes, (int)pos);
                if (shouldSwap) {
                    s = ArrayUtils.swapEndian((int)s);
                }
                return s;
            }
            case "getlong": {
                ReferenceObject referenceObject = (ReferenceObject)this._arguments.get(0);
                byte[] bytes = (byte[])referenceObject.execute(scope);
                int pos = Integer.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                boolean shouldSwap = false;
                if (3 <= this._arguments.size()) {
                    shouldSwap = Boolean.valueOf(((AbstractNode)this._arguments.get(2)).execute(scope).toString());
                }
                long l = ArrayUtils.getLong((byte[])bytes, (int)pos);
                if (shouldSwap) {
                    l = ArrayUtils.swapEndian((long)l);
                }
                return l;
            }
            case "getdouble": {
                ReferenceObject referenceObject = (ReferenceObject)this._arguments.get(0);
                byte[] bytes = (byte[])referenceObject.execute(scope);
                System.out.println(HexUtils.bytesToHex(bytes));
                int pos = Integer.valueOf(((AbstractNode)this._arguments.get(1)).execute(scope).toString());
                System.out.println("pos: " + pos);
                boolean shouldSwap = false;
                if (3 <= this._arguments.size()) {
                    shouldSwap = Boolean.valueOf(((AbstractNode)this._arguments.get(2)).execute(scope).toString());
                }
                long l = ArrayUtils.getLong((byte[])bytes, (int)pos);
                if (shouldSwap) {
                    l = ArrayUtils.swapEndian((long)l);
                }
                double d = Double.longBitsToDouble(l);
                System.out.println(this + " = " + d);
                return d;
            }
        }
        return null;
    }
}

