/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices.soundprocessors;

import com.integ.tasker.devices.soundprocessors.SoundProcessorDevice;
import java.util.Json;

public class DolbyCP650
extends SoundProcessorDevice {
    public DolbyCP650(Json json) {
        super(json);
        if (0 == this._port) {
            this._port = 61412;
        }
    }

    @Override
    public byte[] getCommandBytes(Json actionParamsJson) {
        String deviceAction = actionParamsJson.getString("DeviceAction");
        System.out.printf("soundprocessorsend device action: %s\n", new Object[]{deviceAction});
        String commandString = "";
        switch (deviceAction) {
            case "master-mute": {
                commandString = "mute=1\r\n";
                break;
            }
            case "master-unmute": {
                commandString = "mute=0\r\n";
                break;
            }
            case "fader-level": {
                int level = actionParamsJson.getInt("Level");
                commandString = String.format("fader_level=%d\r\n", level);
                break;
            }
            case "format-button": {
                int button = actionParamsJson.getInt("Button");
                commandString = String.format("format_button=%d\r\n", button);
            }
        }
        return commandString.getBytes();
    }

    public String toString() {
        return String.format("Dolby CP650 %s:%d", this._ipAddress, this._port);
    }
}

