/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.resettypes;

import com.integ.tasker.IOMonitors;
import com.integ.tasker.Unloadable;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.iolog.IoChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import java.util.Json;

public class DiscreteSignalReset
extends Reset
implements IoChannelLogListener,
Unloadable {
    private final Json _paramsJson;
    private final String _signalProfileName;
    private final String _resetState;
    private SignalProfile _signalProfile;

    public DiscreteSignalReset(Json resetJson) {
        this._paramsJson = (Json)resetJson.get("Params");
        this._resetState = this._paramsJson.getString("State");
        Json resetSignalJson = (Json)this._paramsJson.get("Signal");
        this._signalProfileName = resetSignalJson.getString("Name");
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
        SignalProfilesCollection signalProfilesCollection = workspaceConfigurationFile.getSignalProfilesCollection();
        if (signalProfilesCollection.containsSignalProfileName(this._signalProfileName)) {
            this._signalProfile = signalProfilesCollection.getByName(this._signalProfileName);
        }
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.addDigitalInputListener(this._signalProfile.Channel, this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.addDigitalOutputListener(this._signalProfile.Channel, this);
        }
    }

    @Override
    public void unload() {
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.removeDigitalInputListener(this._signalProfile.Channel, this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.removeDigitalOutputListener(this._signalProfile.Channel, this);
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        if (ioEvent.Channel == this._signalProfile.Channel) {
            System.out.println(String.format("Discrete Reset Channel: %d, Channel Changed: %d", this._signalProfile.Channel, ioEvent.Channel));
            System.out.println(String.format("Discrete Reset Trigger State: %s, IO State: %s", String.valueOf(this._resetState), String.valueOf(ioEvent.State)));
            if ("either".equalsIgnoreCase(this._resetState)) {
                this.resetTrigger();
            } else if (ioEvent.State && "high".equalsIgnoreCase(this._resetState)) {
                this.resetTrigger();
            } else if (!ioEvent.State && "low".equalsIgnoreCase(this._resetState)) {
                this.resetTrigger();
            }
        }
    }
}

