/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Scope;
import com.integpg.system.JANOS;
import java.io.IOException;

public class ScriptTest {
    private static final ExpressionEngine EXPRESSION_Engine = new ExpressionEngine();
    private static final Scope SCOPE = new Scope();

    private static void setDebug(boolean debug) {
        EXPRESSION_Engine.setDebug(debug);
        SCOPE.setDebug(debug);
    }

    public static void main(String[] args) throws Exception {
        int i;
        boolean result;
        ScriptTest.setDebug(true);
        ScriptTest.assertEquals("true", true);
        ScriptTest.assertEquals("false", false);
        Object leftResultObject = true;
        Object rightResultObject = "true";
        int iterations = 5000;
        if (leftResultObject instanceof Boolean && rightResultObject instanceof Boolean) {
            result = ((Boolean)leftResultObject).equals((Boolean)rightResultObject);
        } else if (leftResultObject instanceof Number && rightResultObject instanceof Number) {
            result = ((Number)leftResultObject).doubleValue() == ((Number)rightResultObject).doubleValue();
        } else {
            if (!(leftResultObject instanceof String)) {
                leftResultObject = String.valueOf(leftResultObject);
            } else if (!(rightResultObject instanceof String)) {
                rightResultObject = String.valueOf(rightResultObject);
            }
            result = ((String)leftResultObject).equals(rightResultObject);
        }
        if (!result) {
            System.out.println("ERROR");
        }
        System.out.println("bool, bool");
        long start = System.currentTimeMillis();
        leftResultObject = true;
        rightResultObject = true;
        for (i = 0; i < iterations; ++i) {
            result = String.valueOf(leftResultObject).equals(String.valueOf(rightResultObject));
            if (result) continue;
            System.out.println("ERROR");
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed = " + elapsed);
        System.out.println("bool, string");
        start = System.currentTimeMillis();
        leftResultObject = true;
        rightResultObject = "true";
        for (i = 0; i < iterations; ++i) {
            result = String.valueOf(leftResultObject).equals(String.valueOf(rightResultObject));
            if (result) continue;
            System.out.println("ERROR");
        }
        elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed = " + elapsed);
        System.out.println("string, string");
        start = System.currentTimeMillis();
        leftResultObject = "true";
        rightResultObject = "true";
        for (i = 0; i < iterations; ++i) {
            result = String.valueOf(leftResultObject).equals(String.valueOf(rightResultObject));
            if (result) continue;
            System.out.println("ERROR");
        }
        elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed = " + elapsed);
    }

    private static void setOutputs(int statesMask, int bitsMask) throws IOException {
        for (int i = 0; i < 16 && 0 != bitsMask; bitsMask >>= 1, ++i) {
            if (1 == (bitsMask & 1)) {
                boolean channelState = 1 == (statesMask & 1);
                System.out.println(String.format("set output %d %s", i + 1, channelState ? "ON" : "OFF"));
                JANOS.setOutputRelay((int)i, (boolean)channelState);
            }
            statesMask >>= 1;
        }
    }

    private static void assertEquals(String script, Object expectedResult) {
        try {
            System.out.println("\r\n\r\nscript:\r\n" + script);
            long startParse = System.currentTimeMillis();
            EXPRESSION_Engine.parse(script);
            long elapsedParse = System.currentTimeMillis() - startParse;
            long startExecute = System.currentTimeMillis();
            Object result = EXPRESSION_Engine.execute(SCOPE);
            long elapsedExecute = System.currentTimeMillis() - startExecute;
            long elapsedTotal = elapsedParse + elapsedExecute;
            System.out.println("result = " + result);
            System.out.println(String.format("  elapsed parse %lld", elapsedParse));
            System.out.println(String.format("  elapsed execute %lld", elapsedExecute));
            System.out.println(String.format("  total elapsed %lld", elapsedTotal));
            System.out.println("result = " + result + " " + result.getClass());
            System.out.println("expectedResult = " + expectedResult + " " + expectedResult.getClass());
            if (result instanceof Double && expectedResult instanceof Integer) {
                expectedResult = ((Integer)expectedResult).doubleValue();
            }
            if (!expectedResult.equals(result)) {
                throw new RuntimeException(String.format("The script %s does not result to %s", script, String.valueOf(expectedResult)));
            }
            System.out.println("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

