/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.tasker.Unloadable;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.UDPServerDevice;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.Json;

public class UDPReceiveTrigger
extends Trigger
implements Unloadable {
    private final Json _paramsJson;

    public UDPReceiveTrigger(Json triggerJson) {
        this._paramsJson = (Json)triggerJson.get("Params");
        System.out.println("add udp receive trigger");
        String deviceGuid = this._paramsJson.getString("DeviceGUID");
        DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
        if (null == device) {
            throw new RuntimeException("No device found for " + deviceGuid);
        }
        if (!(device instanceof UDPServerDevice)) {
            throw new RuntimeException("Device found for " + deviceGuid + " is not an UDP Server Device");
        }
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
    }

    @Override
    public void unload() {
    }
}

