/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.scripting.ScriptTest;
import com.integ.tasker.AssemblyInfo;
import com.integ.tasker.Config;
import com.integ.tasker.FileSystemMonitor;
import com.integ.tasker.TaskerAsciiCommandSerialClient;
import com.integ.tasker.TaskerAsciiCommandServer;
import com.integ.tasker.schedules.ScheduleMonitor;
import com.integ.tasker.web.handlers.AnnounceRequestHandler;
import com.integ.tasker.web.handlers.ConfigurationUpdatedHandler;
import com.integ.tasker.web.handlers.TaskExecuteHandler;
import com.integ.tasker.web.handlers.TasksGetHandler;
import com.integ.tasker.web.messages.AnnounceMessage;
import com.integ.tasker.web.messages.DeathMessage;
import com.integ.tasker.web.webrequest.GetLoadedTasksRequestHandler;
import com.integ.tasker.web.webrequest.GetTaskDevicesRequestHandler;
import com.integ.tasker.web.webrequest.TaskExecuteRequestHandler;
import com.integ.tasker.workspaces.WorkspaceDirectory;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.messagepump.MessagePumpAppHandler;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.http.server.WebHandlerServer;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.system.JANOS;

public class TaskerMain
extends JanosApplication {
    public static final TaskerMain INSTANCE = new TaskerMain();
    private ControlPanel _controlPanel;

    public static void main(String[] args) throws InterruptedException {
        TaskerMain.exec(INSTANCE, AssemblyInfo.getInstance(), args);
    }

    public static ControlPanel getControlPanel() {
        return TaskerMain.INSTANCE._controlPanel;
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    @Override
    public void init(String[] args) {
        if (1 == args.length && "-scripttest".equalsIgnoreCase(args[0])) {
            try {
                ScriptTest.main(args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.exit(0);
        }
        MessagePumpEngine.start();
        Config.init();
        AppLog.info("add web page listener");
        MessagePumpAppHandler appListener = new MessagePumpAppHandler(2010).addCommandListener("announce.request", new AnnounceRequestHandler()).addCommandListener("tasks.get", new TasksGetHandler()).addCommandListener("task.execute", new TaskExecuteHandler()).addCommandListener("config.updated", new ConfigurationUpdatedHandler());
        MessagePumpEngine.addListener(appListener);
        this.initControlPanel();
        WorkspaceDirectory workspaceDirectory = new WorkspaceDirectory(Config.TASKER_WORKSPACE_DIRECTORY);
        TaskerAsciiCommandServer _asciiProtocol = new TaskerAsciiCommandServer();
        _asciiProtocol.start();
        TaskerAsciiCommandSerialClient.init();
        FileSystemMonitor.start();
        ScheduleMonitor.start();
        this.initWebServer();
    }

    @Override
    public void run() throws InterruptedException {
        AnnounceMessage announceMessage = new AnnounceMessage();
        MessagePumpEngine.postMessage(announceMessage.build());
        while (true) {
            try {
                while (true) {
                    super.feedWatchdog();
                    MessagePumpEngine.postMessage(announceMessage.build());
                    Thread.sleep(15000L);
                }
            }
            catch (Exception ex) {
                AppLog.error(ex);
                continue;
            }
            break;
        }
    }

    private void initControlPanel() {
        System.out.println("init control panel");
        this._controlPanel = ControlPanel.getInstance();
        this._controlPanel.monitorSwitches();
    }

    private void initWebServer() {
        int port = Config.getWebServerPort();
        if (-1 != port) {
            WebHandlerServer webHandlerServer = new WebHandlerServer();
            webHandlerServer.addWebHandler("/executetask", new TaskExecuteRequestHandler());
            webHandlerServer.addWebHandler("/getloadedtasks", new GetLoadedTasksRequestHandler());
            webHandlerServer.addWebHandler("/gettaskdevices", new GetTaskDevicesRequestHandler());
            webHandlerServer.start(port);
        }
    }

    protected void finalize() {
        JANOS.syslog((String)"Tasker exiting...");
        DeathMessage deathMessage = new DeathMessage();
        MessagePumpEngine.postMessage(deathMessage.build());
    }
}

