/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObject;
import com.integ.tasker.tasks.Scope;
import java.util.ArrayList;

public class BlockObject
extends AbstractObject {
    private final ArrayList<AbstractNode> _statements = new ArrayList();

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        System.out.println("block object parse");
        try {
            this._statements.clear();
            while (!parser.isEmpty()) {
                AbstractNode abstractNode = parser.parseStatement();
                System.out.println(String.format("Statement: %s", abstractNode.toString()));
                this._statements.add(abstractNode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ScriptParserException(String.format("error processing script at %d:%d", parser.currentToken().lineNo, parser.currentToken().colPos), ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        Object result = null;
        if (_debug_) {
            System.out.println(String.format("evaluating %d statements...", this._statements.size()));
        }
        for (AbstractNode node : this._statements) {
            if (_debug_) {
                System.out.println(String.format("      evaluate %s (%s)", node.toString(), node.getClass().toString()));
            }
            result = node.execute(scope);
            if (!_debug_) continue;
            System.out.println(String.format("   %s = ", node.toString(), String.valueOf(result)));
        }
        if (1 == this._statements.size()) {
            return result;
        }
        return null;
    }
}

