/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.TextReplacer;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.MailComposer;
import java.util.Json;

public class EmailSendMethod
extends Action {
    private final String _toAddresses;
    private String _ccAddresses;
    private String _bccAddresses;
    private final String _subject;
    private String _attachment;
    private final String _body;

    public EmailSendMethod(Task parentTask, Json json) throws Throwable {
        super(parentTask, json);
        try {
            this._toAddresses = StringUtils.trim(this._paramsJson.getString("ToRecipient"), ' ');
            String ccRecipientString = "";
            if (this._paramsJson.containsKey("CcRecipients") && null != (ccRecipientString = this._paramsJson.getString("CcRecipients")) && 0 < ccRecipientString.length()) {
                ccRecipientString = StringUtils.trim(ccRecipientString, ' ');
            }
            this._ccAddresses = ccRecipientString;
            String bccRecipientString = "";
            if (this._paramsJson.containsKey("BccRecipients") && null != (bccRecipientString = this._paramsJson.getString("BccRecipients")) && 0 < bccRecipientString.length()) {
                bccRecipientString = StringUtils.trim(bccRecipientString, ' ');
            }
            this._bccAddresses = bccRecipientString;
            this._subject = StringUtils.trim(this._paramsJson.getString("Subject"), ' ');
            String attachmentString = null;
            if (this._paramsJson.containsKey("Attachment") && null != (attachmentString = this._paramsJson.getString("Attachment")) && 0 < attachmentString.length()) {
                attachmentString = StringUtils.trim(attachmentString, ' ');
            }
            this._attachment = attachmentString;
            this._body = StringUtils.trim(this._paramsJson.getString("Body"), ' ');
        }
        catch (Exception ex) {
            throw new RuntimeException("Error loading Email Send class").initCause(ex);
        }
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            if (_debug_) {
                System.out.println("EmailSend command");
            }
            String subject = this._subject;
            if (_debug_) {
                System.out.println("subject: " + subject);
            }
            subject = TextReplacer.replace(subject, taskRuntime.Scope);
            if (_debug_) {
                System.out.println("subject: " + subject);
            }
            String message = this._body;
            if (_debug_) {
                System.out.println("message: " + message);
            }
            message = TextReplacer.replace(message, taskRuntime.Scope);
            if (_debug_) {
                System.out.println("message: " + message);
            }
            byte[] messageBytes = StringUtils.getEscapedBytes(message);
            MailComposer mailComposer = new MailComposer();
            if (_debug_) {
                System.out.println("_toAddresses: " + this._toAddresses);
            }
            String toAddresses = TextReplacer.replace(this._toAddresses, taskRuntime.Scope);
            if (_debug_) {
                System.out.println("toAddresses: " + toAddresses);
            }
            String[] toAddressesArray = StringUtils.split(toAddresses, new String[]{",", ";"}, 0);
            mailComposer.setToAddress(toAddressesArray);
            if (_debug_) {
                System.out.println("_ccAddresses: " + this._ccAddresses);
            }
            String ccAddresses = TextReplacer.replace(this._ccAddresses, taskRuntime.Scope);
            if (_debug_) {
                System.out.println("ccAddresses: " + ccAddresses);
            }
            String[] ccAddressesArray = StringUtils.split(ccAddresses, new String[]{",", ";"}, 0);
            mailComposer.setCcAddress(ccAddressesArray);
            if (_debug_) {
                System.out.println("_bccAddresses: " + this._bccAddresses);
            }
            String bccAddresses = TextReplacer.replace(this._bccAddresses, taskRuntime.Scope);
            if (_debug_) {
                System.out.println("bccAddresses: " + bccAddresses);
            }
            String[] bccAddressesArray = StringUtils.split(bccAddresses, new String[]{",", ";"}, 0);
            mailComposer.setBccAddress(ccAddressesArray);
            mailComposer.setSubject(subject);
            if (null != this._attachment) {
                String attachment = TextReplacer.replace(this._attachment, taskRuntime.Scope, "");
                mailComposer.setAttachment(attachment);
            }
            message = new String(messageBytes);
            mailComposer.setMessage(message);
            mailComposer.send();
        }
        catch (Exception ex) {
            throw new Exception("Error executing Email Send").initCause(ex);
        }
    }
}

