/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.workspaces;

import com.integ.tasker.FileModifiedEvent;
import com.integ.tasker.FileModifiedListener;
import com.integ.tasker.FileSystemMonitor;
import com.integ.tasker.workspaces.WorkspaceCollection;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.File;

public class WorkspaceDirectory
implements FileModifiedListener {
    private final File _workspacesDirectory;

    public WorkspaceDirectory(File workspacesDirectory) {
        this._workspacesDirectory = workspacesDirectory;
        this.monitorWorkspaceDirectory();
        this.loadNewWorkspaceFiles(true);
    }

    private void monitorWorkspaceDirectory() {
        AppLog.info("monitor workspace directory");
        FileSystemMonitor.addPath(this._workspacesDirectory, this);
    }

    @Override
    public void directoryModified(FileModifiedEvent fileModifiedEvent) {
        File file = fileModifiedEvent.getFile();
        WorkspaceFile.LOG.info("directory " + file.getPath() + " has been modified at " + QuickDateFormat.getDefault().format(file.lastModified()));
        this.loadNewWorkspaceFiles(false);
    }

    @Override
    public void fileModified(FileModifiedEvent fileModifiedEvent) {
        File file = new File(fileModifiedEvent.getFile().getPath());
        WorkspaceFile.LOG.info("file " + file.getPath() + " has been modified at " + QuickDateFormat.getDefault().format(file.lastModified()));
        WorkspaceFile workspaceFile = WorkspaceCollection.get(file.getPath());
        if (null != workspaceFile) {
            workspaceFile.reload();
        }
    }

    @Override
    public void fileRemoved(FileModifiedEvent fileModifiedEvent) {
        File file = new File(fileModifiedEvent.getFile().getPath());
        WorkspaceFile.LOG.info(file.getPath() + " has been removed");
        WorkspaceFile workspaceFile = WorkspaceCollection.get(file.getPath());
        if (null != workspaceFile) {
            workspaceFile.stop();
            WorkspaceCollection.remove(workspaceFile);
            FileSystemMonitor.removePath(workspaceFile.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNewWorkspaceFiles(boolean initialCheck) {
        File file = this._workspacesDirectory;
        synchronized (file) {
            String[] workspaceFileStrings;
            System.out.println("load workspace files");
            for (String workspaceFilename : workspaceFileStrings = this._workspacesDirectory.list()) {
                if (!workspaceFilename.endsWith(".json")) continue;
                if (workspaceFilename.startsWith("#")) {
                    AppLog.printf("the %s workspace is disabled", workspaceFilename);
                    continue;
                }
                String fullPathName = this._workspacesDirectory.getPath() + workspaceFilename;
                File file2 = new File(fullPathName);
                if (WorkspaceCollection.containsKey(fullPathName)) continue;
                AppLog.printf("Loading new workspace: %s", fullPathName);
                WorkspaceFile workspaceFile = new WorkspaceFile(file2);
                if (!workspaceFile.load()) continue;
                WorkspaceCollection.put(workspaceFile);
                FileSystemMonitor.addPath(file2, this);
            }
        }
    }
}

