/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.RegistryEnumerateModules;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class TypeF9
extends ExternalModule {
    public int[] RawIn = new int[4];
    public double[] ValueIn = new double[4];
    private final byte[] _writeBytes = new byte[16];

    public static TypeF9 getByIndex(int index) {
        String typeString = "TypeF9_" + (index + 1);
        String addressString = JANOS.getRegistryString((String)("externals/deviceorder/" + typeString), null);
        if (null != addressString) {
            if (!ModulesByAddress.containsKey(addressString)) {
                long address = HexUtils.parseHexAsLong(addressString);
                TypeF9 typeF9 = new TypeF9(address);
                typeF9.TypeIndex = index + 1;
                typeF9.TypeString = typeString;
                ModulesByAddress.put(addressString, typeF9);
            }
            return (TypeF9)ModulesByAddress.get(addressString);
        }
        return null;
    }

    public TypeF9(long address) {
        super(address);
    }

    public static TypeF9[] getDeviceArray() {
        RegistryEnumerateModules registryEnumerateModules = new RegistryEnumerateModules("F9");
        String[] externalDeviceAddressStrings = registryEnumerateModules.getExternalDeviceAddressStrings();
        TypeF9[] deviceArray = new TypeF9[externalDeviceAddressStrings.length];
        for (int i = 0; i < externalDeviceAddressStrings.length; ++i) {
            String deviceString = externalDeviceAddressStrings[i];
            long deviceAddress = TypeF9.getDeviceAddressForDeviceString(deviceString);
            deviceArray[i] = new TypeF9(deviceAddress);
            AppLog.vital(deviceString + " = " + deviceArray[i].AddressString);
        }
        return deviceArray;
    }

    protected static ExternalModule createModule(long deviceAddress) {
        return new TypeF9(deviceAddress);
    }

    @Override
    public void read() throws IOException {
        byte[] readDeviceBlock = JANOS.readDeviceBlock((long)this.Address);
        if (readDeviceBlock.length != 16) {
            throw new IOException("Unable to read " + this.AddressString);
        }
        this.LastReadTime = System.currentTimeMillis();
        for (int channel = 0; channel < 4; ++channel) {
            this.RawIn[channel] = ArrayUtils.getShort((byte[])readDeviceBlock, (int)(channel * 2)) & 0xFFFF;
        }
    }

    public void setChannels(int channelMask, double percent) {
        if (0 == channelMask) {
            throw new RuntimeException("channelMask out of range");
        }
        this.fadeChannels(channelMask, percent, 0);
    }

    public void fadeChannels(int channelMask, double percent, int duration) {
        int i;
        if (channelMask > 7) {
            throw new IllegalArgumentException("Channel must be a binary mask between 0x00 and 0x07");
        }
        if (percent > 100.0) {
            throw new IllegalArgumentException("Percent must be between 0 and 100");
        }
        if (duration > 65534) {
            throw new IllegalArgumentException("Fade duration must be between 0 and 65534");
        }
        double val = percent / 100.0;
        val *= 65534.0;
        val += 1.0;
        for (i = 0; i < 3; ++i) {
            if ((channelMask >> i & 1) != 1) continue;
            ArrayUtils.setShort((byte[])this._writeBytes, (int)(i * 2), (short)((short)val));
        }
        for (i = 0; i < 3; ++i) {
            if ((channelMask >> i & 1) != 1) continue;
            ArrayUtils.setShort((byte[])this._writeBytes, (int)(i * 2 + 8), (short)((short)(duration + 1)));
        }
    }

    @Override
    public void commit() {
        try {
            JANOS.writeDeviceBlock((long)this.Address, (byte[])this._writeBytes);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void printValues() {
    }

    @Override
    public double get(String filedName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

