/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class Device {
    protected static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_devices.log").setLogType(LogTypes.HalfBak));
    public String Name;
    public String GUID;

    public Device(Json json) {
        try {
            LOG.info("loading Device from " + json);
            this.Name = json.getString("Name");
            this.GUID = json.getString("GUID");
            LOG.info(String.format("loading device: %s %s", this.Name, this.GUID));
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }
}

