/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks;

import java.util.Enumeration;
import java.util.Hashtable;

public class Scope {
    private static final Scope GLOBAL = new Scope();
    private final Hashtable<String, Object> _varaibles = new Hashtable();
    boolean _debug_;

    public static Scope getGlobal() {
        return GLOBAL;
    }

    public boolean isDebug() {
        return this._debug_;
    }

    public void setDebug(boolean debug) {
        this._debug_ = debug;
    }

    public void setVariable(String variable, Object value) {
        if ("_debug_".equalsIgnoreCase(variable = variable.toLowerCase())) {
            this._debug_ = (Boolean)value;
        } else {
            boolean isGlobal = variable.startsWith("$$");
            if (GLOBAL != this && isGlobal) {
                GLOBAL.setVariable(variable, value);
            }
            if (this._debug_) {
                System.out.println(String.format("   %s - set %s to %s", this.toString(), variable, value.toString()));
            }
            this._varaibles.put(variable, value);
            Scope.getGlobal().print();
        }
    }

    public Object getVariable(String variable) {
        variable = variable.toLowerCase();
        Object value = null;
        boolean isGlobal = variable.startsWith("$$");
        System.out.println("isGlobal: " + isGlobal);
        if (GLOBAL != this && isGlobal) {
            value = GLOBAL.getVariable(variable);
        } else {
            if (!this._varaibles.containsKey(variable)) {
                throw new RuntimeException(String.format("variable \"%s\" does not exist in scope", variable));
            }
            value = this._varaibles.get(variable);
        }
        if (null == value) {
            throw new RuntimeException("scope variable is NULL");
        }
        return value;
    }

    public boolean contains(String variable) {
        variable = variable.toLowerCase();
        boolean isGlobal = variable.startsWith("$$");
        if (GLOBAL != this && isGlobal) {
            return GLOBAL.contains(variable);
        }
        return this._varaibles.containsKey(variable);
    }

    public void print() {
        System.out.println("Globals:");
        Enumeration<String> e = this._varaibles.keys();
        while (e.hasMoreElements()) {
            String variable = e.nextElement();
            Object value = this._varaibles.get(variable);
            System.out.println(String.format("   %s - %s is %s", this.toString(), variable, value.toString()));
        }
    }
}

