/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class TypeF9
extends ExternalModule {
    public int[] RawIn = new int[4];
    public double[] ValueIn = new double[4];
    private final byte[] _writeBytes = new byte[16];

    public static TypeF9 getByIndex(int index) throws IOException {
        return TypeF9.getByNumber(index + 1);
    }

    public static TypeF9 getByNumber(int number) throws IOException {
        String deviceAddressString = ExternalUtils.getDeviceAddressFor("f9", number);
        if (!CACHED_DEVICES.containsKey(deviceAddressString)) {
            long address = HexUtils.parseHexAsLong(deviceAddressString);
            CACHED_DEVICES.put(deviceAddressString, new TypeF9(address, number));
        }
        return (TypeF9)CACHED_DEVICES.get(deviceAddressString);
    }

    public static TypeF9 getByAddress(long deviceAddress) {
        return new TypeF9(deviceAddress, -1);
    }

    TypeF9(long address, int index) {
        super(address, index, "TypeF9");
    }

    @Override
    public void read() throws IOException {
        byte[] readDeviceBlock = JANOS.readDeviceBlock((long)this.Address);
        if (readDeviceBlock.length != 16) {
            throw new IOException("Unable to read " + this.AddressString);
        }
        this.LastReadTime = System.currentTimeMillis();
        for (int channel = 0; channel < 4; ++channel) {
            this.RawIn[channel] = ArrayUtils.getShort((byte[])readDeviceBlock, (int)(channel * 2)) & 0xFFFF;
        }
    }

    public void setChannels(int channelMask, double percent) {
        if (0 == channelMask) {
            throw new RuntimeException("channelMask out of range");
        }
        this.fadeChannels(channelMask, percent, 0);
    }

    public void fadeChannels(int channelMask, double percent, int duration) {
        int i;
        if (channelMask > 7) {
            throw new IllegalArgumentException("Channel must be a binary mask between 0x00 and 0x07");
        }
        if (percent > 100.0) {
            throw new IllegalArgumentException("Percent must be between 0 and 100");
        }
        if (duration > 65534) {
            throw new IllegalArgumentException("Fade duration must be between 0 and 65534");
        }
        double val = percent / 100.0;
        val *= 65534.0;
        val += 1.0;
        for (i = 0; i < 3; ++i) {
            if ((channelMask >> i & 1) != 1) continue;
            ArrayUtils.setShort((byte[])this._writeBytes, (int)(i * 2), (short)((short)val));
        }
        for (i = 0; i < 3; ++i) {
            if ((channelMask >> i & 1) != 1) continue;
            ArrayUtils.setShort((byte[])this._writeBytes, (int)(i * 2 + 8), (short)((short)(duration + 1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        SensorPort sensorPort = SENSOR_PORT;
        synchronized (sensorPort) {
            JANOS.writeDeviceBlock((long)this.Address, (byte[])this._writeBytes);
        }
    }

    @Override
    public void printValues() {
    }

    @Override
    public Object get(String filedName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

