App.controller('Controller', function ($scope, $location) {
    var _this = this;

    _this.FirstLoad = true;
    _this.peerConnections = [];

    // instantiate our jnior websocket object
    var jnrWebsocket = new JnrWebsocket();
    jnrWebsocket.connect();
    jnrWebsocket.enableCommLogging();

    var APP_ID = 2010;
    // onLoggedIn callback.  this is where we will read the config file
    jnrWebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log('onLoggedIn');

        if (_this.FirstLoad) {
            _this.FirstLoad = false;

            // here we get the peers.  we will use the peers to connect to the other 
            // auditoriums.  it is likely that all or most of the jniors in a ibooth
            // complex are meant for this application.
            jnrWebsocket.getRegistryListing('peers', function (node, keys) {
                jnrWebsocket.readRegistryKeys(keys, function (keyName, value) {
                    if (null != value) {
                        var ipAddress = value.split(' ')[0];
                        var series3 = -1 != keyName.indexOf('$1')
                            || -1 != keyName.indexOf('$2')
                            || -1 != keyName.indexOf('$3')
                            || -1 != keyName.indexOf('$4');
                        // ignore blank ip addresses or series 3 jniors
                        if ('0.0.0.0' != ipAddress && !series3) {
                            createPeerConnection(ipAddress);
                        }
                    }
                });
            });

            _this.peerConnections.push(new PeerConnection(jnrWebsocket));
            $scope.$apply();
        }
    });



    function createPeerConnection(ipAddress) {
        var newJnrWebsocket = new JnrWebsocket();
        newJnrWebsocket.connect('ws://' + ipAddress);
        newJnrWebsocket.enableCommLogging();
        newJnrWebsocket.addOnLoggedInListener(function onLoggedIn() {
            console.log('onLoggedIn');

            _this.peerConnections.push(new PeerConnection(newJnrWebsocket));
            $scope.$apply();
        });
    }



    function PeerConnection(jnrWebsocket) {
        var _this = this;
        _this.jnrWebsocket = jnrWebsocket;
        _this.HasTasker = false;
        _this.TaskerActive = false;
        _this.Object = { PeerConnection: this };
        _this.FirstAnnounce = true;
        _this.LastAnnouncementTime = 0;
        _this.LastAnnouncementRequestTime = new Date().getTime();
        _this.TimeSinceLastAnnouncement = 0;

        _this.IntervalTimer = setInterval(function () {
            var now = new Date().getTime();
            _this.TimeSinceLastAnnouncement = now - _this.LastAnnouncementTime;
            _this.TaskerActive = 15000 > _this.TimeSinceLastAnnouncement;
            $scope.$apply();

            // what to do when it is not active?
            if (!_this.TaskerActive) {
                // if (_this.FirstAnnounce) {
                // clearTimeout(_this.IntervalTimer);
                // _this.IntervalTimer = null;
                // _this.jnrWebsocket.close();
                // } else {
                _this.FirstAnnounce = true;

                if (15000 < now - _this.LastAnnouncementRequestTime) {
                    _this.jnrWebsocket.postMessage(APP_ID, { Message: 'announce.request' });
                    _this.LastAnnouncementRequestTime = new Date().getTime();
                }

                // }
            } else {
                _this.HasTasker = true;

            }
        }, 1000);


        _this.jnrWebsocket.readRegistryKeys(['ipconfig/ipaddress', 'ipconfig/hostname', '$version'], function (keyName, value) {
            if (null != value) {
                if ("ipconfig/ipaddress" == keyName) {
                    _this.Object.IpAddress = value;
                } else if ("ipconfig/hostname" == keyName) {
                    _this.Object.Hostname = value;
                } else if ("$version" == keyName) {
                    _this.Object.Version = value;
                }

                $scope.$apply();
            }
        });



        _this.jnrWebsocket.addOnMessageListener(function (jsonReply) {
            var message = jsonReply.Message;

            if ("announce" === message) {
                _this.LastAnnouncementTime = new Date().getTime();
                _this.TaskerActive = true;

                /* we received this message.  if the timeout timer exists then cancel it.  this
                also indeicates the first message received. */
                if (_this.FirstAnnounce) {
                    _this.FirstAnnounce = false;

                    // clearTimeout(_this.timeoutTimer);
                    // _this.timeoutTimer = null;
                    // clearTimeout(_this.IntervalTimer);
                    // _this.IntervalTimer = null;

                    _this.Object.TaskerVersion = jsonReply.Version;

                    _this.Object.TaskMessage = "Fetching Tasks...";
                    _this.jnrWebsocket.postMessage(APP_ID, { Message: 'tasks.get' })
                    _this.fetchTaskTimer = setTimeout(function () {
                        if (undefined == _this.Object.TaskNames) {
                            _this.Object.TaskMessage = "Unable to Fetch Tasks";
                        } else if (0 == _this.Object.TaskNames.length) {
                            _this.Object.TaskMessage = "No Tasks Loaded";
                        }
                    }, 1000);

                    $scope.$apply();
                }

                /* update the saved data */
                // _this.Auditoriums[_this.AuditoriumObject.AuditoriumNumber - 1].Data = jsonReply.Data;

            } else if ("workspace.loaded" == message) {
                _this.jnrWebsocket.postMessage(APP_ID, { Message: 'tasks.get' })

            } else if ("tasks.list" == message) {
                _this.Object.TaskNames = jsonReply.Names;
                $scope.$apply();

            }
        });



        // /* we will request an initial status update to be sent.  when we receive a response we 
        // will add the auditorium object to the array.  if the timeout expires we will close 
        // the connection.  this means that the ibooth application is not running */
        // _this.timeoutTimer = setTimeout(function () {
        //     _this.jnrWebsocket.close();
        // }, 5000);
        _this.jnrWebsocket.postMessage(APP_ID, { Message: 'announce.request' })
        _this.LastAnnouncementRequestTime = new Date().getTime();



        _this.execTask = function (taskName) {
            var executetaskJson = { Message: 'task.execute', TaskName: taskName };
            _this.jnrWebsocket.postMessage(APP_ID, executetaskJson);
        };

    };
});