/* global bootbox, Tasker */

TaskerApp.controller('SignalController', function ($scope, $compile, SignalService, DevicesService) {
    var _this = this;



    _this.getDevicesInfo = function () {
        return DevicesService.DevicesInfo;
    };



    _this.getDeviceInfoByType = function (type) {
        return DevicesService.getDeviceInfoByType(type);
    };



    _this.areSignalsLoaded = function () {
        return SignalService.SignalsLoaded;
    };



    _this.getSignals = function () {
        return SignalService.SignalsList;
    };



    _this.addSignalProfile = function () {
        if (undefined != _this.addSignalDialog) return;

        _this.addSignalDialog = bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Signal?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success btn-submit'
                }
            },
            callback: function (result) {
                if (result) {
                    if (undefined == SignalService.SignalsList) SignalService.SignalsList = [];

                    // make sure there isnt already one with the same name
                    if (SignalService.SignalsList) {
                        for (var i = 0; i < SignalService.SignalsList.length; i++) {
                            if (SignalService.SignalsList[i].Name === result) {
                                bootbox.alert({
                                    className: 'bb-danger',
                                    title: "Duplicate Signal Name",
                                    message: "Signal already exists with the name: <b>" + result + '</b>'
                                });
                                return false;
                            }
                        }
                    }

                    SignalService.SignalsList.push({ Name: result, Params: { Enabled: true }, GUID: guid() });
                    SignalService.parseSignalList(SignalService.SignalsList);
                    $scope.$apply();
                } else return (null == result);
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox"));

            var newName = getNextAvailableName(SignalService.SignalsList, "New_Signal");
            $(".bootbox-input-text").val(newName);
        }).on('hidden.bs.modal', function () {
            _this.addSignalDialog = undefined;
        });
    };



    _this.editSignalName = function (signal) {
        if (undefined != _this.editSignalNameDialog) return;

        _this.editSignalNameDialog = bootbox.prompt({
            className: 'bb-success',
            title: "Edit the name of the Signal?",
            message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
                ' Signal can have negative consequences if it it referenced elsewhere in Tasker. ' +
                ' Please make sure to change the name used in the references.</p>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: signal.Name,
            callback: function (result) {
                if (result) {
                    signal.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox"));
        }).on('hidden.bs.modal', function () {
            _this.editSignalNameDialog = undefined;
        });
    };



    _this.removeSignalProfile = function (signalProfile) {
        if (undefined != _this.removeSignalDialog) return;

        _this.removeSignalDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to remove the " + signalProfile.Name + " signal profile?",
            message: "Are you sure you want to remove the <b>" + signalProfile.Name + "</b> signal profile?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    for (var i = SignalService.SignalsList.length - 1; i >= 0; i--) {
                        if (SignalService.SignalsList[i] === signalProfile) {
                            SignalService.SignalsList.splice(i, 1);
                            $scope.$apply();
                            return;
                        }
                    }
                }
            }
        });
        _this.removeSignalDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
            confirm_or_submit_on_enter($(".bootbox"));
        }).on('hidden.bs.modal', function () {
            _this.removeSignalDialog = undefined;
        });
    };



    _this.updatedType = function () {
        SignalService.parseSignalList(SignalService.SignalsList);
    };



    _this.moveUp = function (signalProfile, currentIndex) {
        // remove from current position
        SignalService.SignalsList.splice(currentIndex, 1);

        // assign the signal to the previous position 
        SignalService.SignalsList.splice(currentIndex - 1, 0, signalProfile);
    };



    _this.moveDown = function (signalProfile, currentIndex) {
        // remove from current position
        SignalService.SignalsList.splice(currentIndex, 1);

        // assign the signal to the previous position 
        SignalService.SignalsList.splice(currentIndex + 1, 0, signalProfile);
    };
});



/*
   SERVICE
*/
TaskerApp.service('SignalService', function ($rootScope, DevicesService) {
    var _this = this;
    _this.SignalsList = [];
    _this.SelectedSignal = null;
    _this.SignalsLoaded = false;
    _this.DiscreteSignalsList = [];
    _this.ContinuousSignalsList = [];




    _this.load = function (deviceListJson) {
        if (undefined == deviceListJson) deviceListJson = [];

        try {
            _this.parseSignalList(deviceListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedSignal = null;
        _this.SignalsLoaded = true;

        return _this.SignalsList;
    };



    _this.parseSignalList = function (signalArray) {
        _this.SignalsList = signalArray;
        _this.DiscreteSignalsList = [];
        _this.ContinuousSignalsList = [];

        _this.DiscreteSignalsList.push({ "Name": "Any Input", "SelectedDevice": "DIN", "SelectedDeviceChannel": -1, "SelectedDeviceVariable": "State" });
        _this.DiscreteSignalsList.push({ "Name": "Any Output", "SelectedDevice": "ROUT", "SelectedDeviceChannel": -1, "SelectedDeviceVariable": "State" });

        _this.SignalsList.forEach(function (signal) {
            if ("DIN" == signal.SelectedDevice || "ROUT" == signal.SelectedDevice) {
                _this.DiscreteSignalsList.push(signal);
            } else {
                _this.ContinuousSignalsList.push(signal);
            }
        });

        console.log('DiscreteSignalsList length: ' + _this.DiscreteSignalsList.length);
    }



    _this.isValid = true;
    _this.validate = function () {
        var form = $("#signals-form");
        if (0 < form.length) {
            form.validate({ ignore: ".ignore", errorPlacement: function (error, element) { } });
            _this.isValid = form.valid();
        } else _this.isValid = true;
        return _this.isValid;
    };
});