/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.workspaces;

import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class WorkspaceCollection {
    private static final Hashtable<String, WorkspaceFile> COLLECTION = new Hashtable();

    public static Hashtable<String, WorkspaceFile> getWorkspaces() {
        return COLLECTION.clone();
    }

    public static WorkspaceFile[] getWorkspacesArray() {
        Hashtable<String, WorkspaceFile> clonedHashtable = WorkspaceCollection.getWorkspaces();
        ArrayList<WorkspaceFile> workspaceArrayList = new ArrayList<WorkspaceFile>();
        Enumeration<WorkspaceFile> workspaceEnumeration = clonedHashtable.elements();
        while (workspaceEnumeration.hasMoreElements()) {
            workspaceArrayList.add(workspaceEnumeration.nextElement());
        }
        WorkspaceFile[] workspaceArray = (WorkspaceFile[])workspaceArrayList.toArray();
        return workspaceArray;
    }

    public static boolean containsKey(String path) {
        return COLLECTION.containsKey(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Hashtable<String, WorkspaceFile> hashtable = COLLECTION;
        synchronized (hashtable) {
            COLLECTION.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(WorkspaceFile workspace) {
        Hashtable<String, WorkspaceFile> hashtable = COLLECTION;
        synchronized (hashtable) {
            COLLECTION.put(workspace.getFile().getPath(), workspace);
        }
    }

    public static WorkspaceFile get(String path) {
        return COLLECTION.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(WorkspaceFile workspaceFile) {
        Hashtable<String, WorkspaceFile> hashtable = COLLECTION;
        synchronized (hashtable) {
            COLLECTION.remove(workspaceFile.getFile().getPath());
        }
    }
}

