/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.Reset;
import com.integpg.janoslib.externalio.controlpanel.ControlPanelListener;
import java.util.Json;

class DiscreteReset
extends Reset
implements IoChannelLogListener,
ControlPanelListener {
    private final SignalProfile _resetSignalProfile;
    private String _resetState;
    private boolean _isReset;

    public DiscreteReset(SignalProfile resetSignalProfile, Json resetJson) {
        this._resetSignalProfile = resetSignalProfile;
        System.out.println("resetJson: " + resetJson);
        this._resetState = resetJson.getString("State");
        System.out.println("_resetState: " + this._resetState);
        if ("din".equalsIgnoreCase(this._resetSignalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.addDigitalInputListener(this);
        } else if ("rout".equalsIgnoreCase(this._resetSignalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.addDigitalOutputListener(this);
        } else if ("ctrlpnl".equalsIgnoreCase(this._resetSignalProfile.DeviceType)) {
            TaskerMain.getControlPanel().addListener(this);
        }
    }

    @Override
    public void makeReset() {
        if ("high".equalsIgnoreCase(this._resetState)) {
            this._resetState = "low";
        } else if ("low".equalsIgnoreCase(this._resetState)) {
            this._resetState = "high";
        }
    }

    @Override
    public void clearReset() {
        this._isReset = false;
    }

    @Override
    public boolean checkForReset() throws Throwable {
        return this._isReset;
    }

    public String toString() {
        return " will reset when " + this._resetSignalProfile.DeviceType + this._resetSignalProfile.Channel + " is " + this._resetState;
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        System.out.println("digitalInput.Channel: " + ioEvent.Channel + ", _resetSignalProfile.Channel: " + this._resetSignalProfile.Channel);
        if (ioEvent.Channel == this._resetSignalProfile.Channel) {
            System.out.println("_resetState: " + this._resetState + ", digitalInput.State: " + ioEvent.State);
            if ("high".equalsIgnoreCase(this._resetState)) {
                this._isReset = ioEvent.State;
            } else if ("low".equalsIgnoreCase(this._resetState)) {
                this._isReset = !ioEvent.State;
            }
        }
    }

    @Override
    public boolean switchesPressed(Object source, int channelMask) {
        return true;
    }

    @Override
    public boolean switchPressed(Object source, final int channel, final int count) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println(String.format("switch pressed: %d, %d time(s)", channel, count));
                if (channel == ((DiscreteReset)DiscreteReset.this)._resetSignalProfile.Channel) {
                    System.out.println("control panel reset");
                    DiscreteReset.this._isReset = true;
                }
            }
        }).start();
        return true;
    }
}

