/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.RunningTaskCollection;
import com.integ.tasker.tasks.Scope;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskResult;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.tasks.actions.ActionFactory;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integ.tasker.web.messages.StatusUpdateMessage;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.ArrayList;
import java.util.Json;

public class Task {
    public String Name;
    public String FullName;
    public String Description;
    private final TaskConfiguration _taskConfiguration;
    private final WorkspaceFile _workspace;
    private boolean _enabled;
    private Action _baseAction;
    private ArrayList<Json> _deviceActionsJson = new ArrayList();

    public Task(TaskConfiguration taskConfiguration, WorkspaceFile workspace) {
        this._taskConfiguration = taskConfiguration;
        this._workspace = workspace;
    }

    public TaskConfiguration getTaskConfiguration() {
        return this._taskConfiguration;
    }

    public Action getBaseAction() {
        return this._baseAction;
    }

    public void load(Json taskJson) {
        try {
            Action baseAction;
            this.Name = taskJson.getString("Name");
            this.FullName = String.format("%s::%s", this._taskConfiguration.getWorkspaceConfigurationFile().getName(), this.Name);
            TaskConfiguration.LOG.info(String.format("loading task \"%s\"", this.FullName));
            this._enabled = taskJson.getBoolean("Enabled");
            if (!this._enabled) {
                TaskConfiguration.LOG.info(this.FullName + " is not enabled");
            }
            Json baseActionJson = (Json)taskJson.get("Action");
            this._baseAction = baseAction = ActionFactory.getActionClass(this, baseActionJson);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            TaskConfiguration.LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public WorkspaceFile getWorkspace() {
        return this._workspace;
    }

    public String getParentWorkspaceName() {
        return this._workspace.getName();
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public void addDeviceActionJson(Json deviceActionJson) {
        this._deviceActionsJson.add(deviceActionJson);
    }

    public ArrayList<Json> getDeviceActionJsonList() {
        return this._deviceActionsJson;
    }

    public void cleanup() {
    }

    public TaskResult execute(String callingObjectName) throws Throwable {
        return this.execute(callingObjectName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(String callingObjectName, Scope scope) throws Throwable {
        long startTime = System.currentTimeMillis();
        TaskResult result = TaskResult.SUCCESS;
        if (this._enabled) {
            StatusUpdateMessage message = new StatusUpdateMessage(String.format(callingObjectName + " is Executing %s", this.Name));
            MessagePumpEngine.postMessage(message.build());
            if (null == scope) {
                scope = new Scope();
            }
            TaskRuntime taskRuntime = new TaskRuntime(this, scope);
            taskRuntime.Scope.setVariable("task.caller", callingObjectName);
            RunningTaskCollection.registerTask(taskRuntime);
            try {
                if (null == this._baseAction) {
                    throw new RuntimeException(String.format("Base action is null for %s", this.FullName));
                }
                TaskConfiguration.LOG.info(String.format("execute %s", this.FullName));
                this._baseAction.execute(taskRuntime);
                long elapsed = System.currentTimeMillis() - startTime;
                TaskConfiguration.LOG.info(String.format("%s executed in %.2f secs", this.FullName, (double)elapsed / 1000.0));
            }
            catch (Throwable ex) {
                if (!taskRuntime.Cancelled) {
                    result = TaskResult.FAILED;
                    throw new Exception(String.format("error executing task \"%s\" in workspace \"%s\"", this.Name, this._taskConfiguration.getWorkspaceConfigurationFile().getName())).initCause(ex);
                }
                result = TaskResult.CANCELLED;
            }
            finally {
                RunningTaskCollection.unregisterTask(taskRuntime);
            }
            if (TaskResult.SUCCESS == result) {
                message = new StatusUpdateMessage(String.format("%s finished", this.Name));
            } else if (TaskResult.FAILED == result) {
                message = new StatusUpdateMessage(String.format("%s failed", this.Name));
            } else if (TaskResult.CANCELLED == result) {
                message = new StatusUpdateMessage(String.format("%s was cancelled", this.Name));
            }
            MessagePumpEngine.postMessage(message.build());
        }
        return result;
    }
}

