TaskerApp.controller('TaskerController',
    function ($scope, $location, $sce, $compile,
        WorkspaceFileService, TaskService, DeviceService, SignalService,
        TriggerService, ScheduleService, LoggerService) {

        var _this = this;

        _this.DaysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

        _this.WebVersion = APP.getVersion();
        _this.Version = 'not running';
        _this.IsRunning = false;

        _this.Workspaces = [];
        _this.Workspace = null;

        _this.knownDevices = [];
        _this.Signals = [];
        _this.Devices = [];
        _this.Config = {
            Version: _this.WebVersion,
            TaskList: [],
            DevicesList: [],
            ScheduleList: [],
            SignalList: [],
            TriggerList: [],
            LoggerList: []
        };
        _this.SavedConfig = angular.copy(_this.Config);

        _this.SaveDialog = null;
        _this.CancelDialog = null;



        _this.getJson = function (json) {

            if (undefined == json || null == json) {
                json = _this.Config;
            }

            return JSON.stringify(json, function replacer(key, value) {
                // remove $$hashKey object as well as references to a parent
                if ('$$hashKey' === key || 'Parent' === key) {
                    return;
                }
                // remove any empty objects.
                if ('Err' === key) { //{} == value) {
                    return;
                }
                return value;
            }, 2);
        };



        _this.new = function () {
            _this.Workspace = '';
            _this.Config = {
                Version: _this.WebVersion,
                TaskList: [],
                DevicesList: [],
                ScheduleList: [],
                SignalList: [],
                TriggerList: [],
                LoggerList: []
            };
            _this.parseConfig(_this.Config);
            $location.search('workspace', undefined);
            $location.search('view', undefined);
        };



        _this.close = function () {
            // check if there are currently changes being made
            var changesInProgress = _this.hasChanged();
            if (changesInProgress) {
                bootbox.alert({
                    title: "There are changes in progress",
                    message: "Sorry.  You cannot switch tabs while there are currently changes in progress.  The changes must either be saved or cancelled."
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4c");
                    $(".modal-header").css("color", "#fff");
                });

            } else {
                // JnrWebsocket.getFileListing('/flash/tasker/workspaces')
                //     .then(function (response) {
                //         response.Content = response.Content.filter(function (element) {
                //             return element.Name.endsWith('.json');
                //         });
                //         response.Content.sort(function (a, b) {
                //             return a.Name.toLowerCase().localeCompare(b.Name.toLowerCase());
                //         });
                //         _this.Workspaces = response.Content;
                //         $scope.$apply();
                //     });

                _this.new();
                _this.Workspace = undefined;
                $scope.$apply();
            }
        };



        _this.open = function (workspaceName) {
            $location.search('workspace', workspaceName);
            _this.load();
        };



        _this.configReceived = function (result) {
            if ('Fail' !== result.Status) {

                var fileContents = Base64.decode(result.Data);
                var configJson = JSON.parse(fileContents);
                _this.parseConfig(configJson);
            }
        };



        _this.parseConfig = function (configJson) {
            try {
                _this.Config.TaskList = TaskService.load(configJson.TaskList);
                _this.Config.DeviceList = DeviceService.load(configJson.DeviceList);
                _this.Config.ScheduleList = ScheduleService.load(configJson.ScheduleList);
                _this.Config.SignalList = SignalService.load(configJson.SignalList);
                _this.Config.TriggerList = TriggerService.load(configJson.TriggerList);
                _this.Config.LoggerList = LoggerService.load(configJson.LoggerList);

                _this.SavedConfig = angular.copy(_this.Config);
            } catch (err) {
                console.error(err);
            }

            $scope.$apply();

            setTimeout(function () {
                $('[data-toggle="tooltip"]').tooltip();
            }, 100);
        };



        _this.View = null;

        // watch for changes to our $location.url() object.
        $scope.$watch(function () {
            return $location.url();
        }, function (url) {
            if (url) {
                var view = $location.search().view;
                if (view) {
                    _this.setView(view);
                } else {
                    _this.setView(null);
                }

                var workspaceName = $location.search().workspace;
                if (undefined != workspaceName && _this.Workspace != workspaceName) {
                    _this.Workspace = workspaceName;
                    JnrWebsocket.readFile('/flash/tasker/workspaces/' + workspaceName, _this.configReceived);
                }
            }
        });


        _this.CurrentService = TaskService;

        // push the view selection to our $location.url() object.
        _this.setView = function (view) {
            if (_this.View == view) return;

            // chack to see if the current service is valid before switching tabs
            var valid = true;
            if (_this.CurrentService && null != _this.CurrentService && _this.CurrentService != TaskService) {
                valid = _this.CurrentService.validate();
            }
            if (!valid) return;

            // check if there are currently changes being made
            // DEBUG
            // seeing if testing for changes is necessary
            var changesInProgress = false; // _this.hasChanged();
            if (changesInProgress) {
                bootbox.alert({
                    title: "There are changes in progress",
                    message: "Sorry.  You cannot switch tabs while there are currently changes in progress.  The changes must either be saved or cancelled."
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4c");
                    $(".modal-header").css("color", "#fff");
                });

            } else {
                _this.View = view;
                if (null != view) {
                    if (null === _this.View || "tasks" === _this.View) {
                        _this.CurrentService = TaskService;
                    } else if ("device-profiles" === _this.View) {
                        _this.CurrentService = DeviceService;
                    } else if ("signal-profiles" === _this.View) {
                        _this.CurrentService = SignalService;
                    } else if ("trigger-profiles" === _this.View) {
                        _this.CurrentService = TriggerService;
                    } else if ("schedule" === _this.View) {
                        _this.CurrentService = ScheduleService;
                    } else if ("logging-profiles" === _this.View) {
                        _this.CurrentService = LoggerService;
                    }

                    $location.search('view', view);
                    _this.load();

                }
            }
        };


        _this.activateView = function (ele) {
            $compile(ele.contents())($scope);
            $scope.$apply();
        };



        _this.getWorkspaceFiles = function () {
            JnrWebsocket.getFileListing('/flash/tasker/workspaces')
                .then(function (response) {
                    response.Content = response.Content.filter(function (element) {
                        return element.Name.endsWith('.json');
                    });
                    response.Content.sort(function (a, b) {
                        return a.Name.toLowerCase().localeCompare(b.Name.toLowerCase());
                    });
                    _this.Workspaces = response.Content;
                    $scope.$apply();
                });
        };



        _this.JniorTimeOffset = -1;
        setInterval(function () {
            if (-1 != _this.JniorTimeOffset) {
                var timestamp = new Date().getTime() + _this.JniorTimeOffset;
                _this.JniorTime = moment(timestamp).format('MMMM Do YYYY, h:mm:ss a');
                $scope.$apply();
            } else {
                _this.JniorTime = '';
            }
        }, 750);



        JnrWebsocket.addOnLoggedInListener(function (json) {
            var jniorCurrentTimestamp = json.Timestamp;
            _this.JniorTimeOffset = jniorCurrentTimestamp - new Date().getTime();

            // _model = json.Model;
            // var digitalInputsInfo = null;
            // for (var i = 0; i < _this.DevicesInfo.length; i++) {
            //     if (_this.DevicesInfo[i].Type === 'DIN') {
            //         digitalInputsInfo = _this.DevicesInfo[i];
            //     }
            // }

            // if (digitalInputsInfo) {
            //     if (_model.startsWith("410")) {
            //         digitalInputsInfo.Channels = [1, 2, 3, 4, 5, 6, 7, 8];
            //     } else if (_model.startsWith("412")) {
            //         digitalInputsInfo.Channels = [1, 2, 3, 4];
            //     } else if (_model.startsWith("414")) {
            //         digitalInputsInfo.Channels = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
            //     }
            // }

            // get the workspace files on load and periodically
            _this.getWorkspaceFiles();
            setInterval(_this.getWorkspaceFiles, 30000);

            JnrWebsocket.readRegistryKey('$LastNtpSuccess', function (key, value) {
                _this.LastNtpSuccess = value;
                $scope.$apply();
            });

            _this.load();
        });




        _this.workspaceFileUploadRequest = function () {
            if (_this.hasChanged(_this.Config, _this.SavedConfig)) {
                _this.SaveDialog = bootbox.dialog({
                    className: 'bb-primary',
                    title: "Changes have been made to Unsaved Workspace",
                    message: "Changes have been made to the current worksapce.  Proceeding to " +
                        "upload a new workspace will close the current workspace and open the " +
                        "new workspace.  Changes would be lost.  How do you wish to proceed?",
                    buttons: {
                        cancel: {
                            label: 'Cancel',
                            className: 'btn-default'
                        },
                        saveAndContinue: {
                            label: 'Continue Anyway',
                            className: 'btn-warning',
                            callback: function () {
                                _this.workspaceFileUpload();
                            }
                        },
                        continue: {
                            label: 'Save and Continue',
                            className: 'btn-success',
                            callback: function () {
                                _this.save(function () {
                                    _this.workspaceFileUpload();
                                });
                            }
                        }
                    },
                });

            } else {
                _this.workspaceFileUpload();
            }
        };



        _this.workspaceFileUpload = function () {
            var $uploadFile = $('#workspace-file-upload');
            var fileCtrl = $uploadFile[0];
            fileCtrl.onchange = function (evt) {
                var file = evt.target.files[0];
                WorkspaceFileService.uploadFile(file);
            };
            fileCtrl.click();
        };



        // _this.downloadFile = function (filename) {
        //     JnrWebsocket.downloadFile(filename).then(function (fileReadJson) {
        //         var workspaceFileDownload = document.getElementById("part-file-download");
        //         workspaceFileDownload.innerHTML = "<a id='download-link' href='" + fileReadJson.Meta + "' target='_blank' download>download</a>";
        //         var downloadLink = document.getElementById("download-link");
        //         downloadLink.click();
        //     });
        // };



        var lastAnnouncementTime = new Date().getTime() - 10000;
        JnrWebsocket.addOnMessageListener(function (json) {
            console.log(JSON.stringify(json, null, 2));

            if ('status.update' == json.Message) {
                toastr.success(json.StatusMessage, new Date() + ' : ' + status.Title);
            }

            else if ('tasks.loaded' == json.Message) {
                var loadTimeInSeconds = json.LoadTime;
                toastr.success('Tasks Loaded in <b>' + loadTimeInSeconds.toFixed(2) + '</b> seconds');
                TaskService.TasksLoaded = true;
                $scope.$apply();

            }

            else if ('error' == json.Message) {
                var message = json.StackTrace ? json.StackTrace.replaceAll('\r\n', '<br>') : '';
                toastr.error(message, json.ErrorMessage, { closeButton: true, timeOut: 10000, extendedTimeOut: 0 });
            }

            else if ('announce' == json.Message) {
                lastAnnouncementTime = new Date().getTime();

                if (null != taskerNotRunningToast) {
                    toastr.clear(taskerNotRunningToast);
                    taskerNotRunningToast = null;
                }

                _this.IsRunning = true;
                _this.Version = json.Version;
                $scope.$apply();

            }
        });
        ``

        JnrWebsocket.connect();
        JnrWebsocket.postMessage(2010, { Message: 'announce.request' });



        var taskerNotRunningToast = null;
        setInterval(function () {
            var now = new Date().getTime();
            var elapsed = now - lastAnnouncementTime;
            // console.log('elapsed: ' + elapsed)
            if (15000 < elapsed) {
                if (null == taskerNotRunningToast) {
                    _this.IsRunning = false;
                    $scope.$apply();

                    taskerNotRunningToast = toastr.error("Unable to communicate with the Tasker application", "Tasker is not running", { closeButton: false, timeOut: 0, extendedTimeOut: 0 });
                } else {
                    JnrWebsocket.postMessage(2010, { Message: 'announce.request' });
                }
            }
        }, 1000);



        _this.load = function (callback) {
            setTimeout(function () {
                JnrWebsocket.readFile('/flash/tasker/workspaces/' + _this.Workspace, callback);
            }, 100);
        };



        // _this.DevicesInfo = [
        //     {
        //         Name: "Digital Input States", Type: "DIN", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], Variables: [
        //             { Name: "Timestamp", Type: "Timestamp", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH" },
        //             { Name: "State", Type: "State", Options: ["High", "Low"], Comparators: ["="], Value: "HIGH" },
        //             { Name: "Counter", Type: "Counter", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH" },
        //             { Name: "Usage Meters", Type: "Usage Meters", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH" }
        //         ]
        //     },
        //     //        {Name: "Digital Input Counters", Type: "DIN_CNT", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], Variables: [{Options: ["Value"], Comparators: [">=", ">"], Value: 12}]},
        //     //        {Name: "Digital Input Usage Meters", Type: "DIN_USE", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], Variables: [{Options: ["Value"], Comparators: [">=", ">"], Value: "3.23 hours"}]},

        //     {
        //         Name: "Relay Output States", Type: "ROUT", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16], Variables: [
        //             { Name: "State", Type: "State", Options: ["High", "Low", "Either"], Comparators: ["="], Value: "HIGH" },
        //             { Name: "Usage Meters", Type: "Usage Meters", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH" }
        //         ]
        //     },
        //     //        {Name: "Relay Output Counters", Type: "ROUT_USE", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16], Variables: [{Options: ["Value"], Comparators: [">=", ">"], Value: "12.87 hours"}]},

        //     {
        //         Name: "Temperature Probe", Type: "Type28", Channels: [1, 2], Variables: [
        //             { Name: "Celsius", Type: "TempC", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "19.76 C" },
        //             { Name: "Fahrenheit", Type: "TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "73.76 F" }
        //         ]
        //     },

        //     {
        //         Name: "Environmental Sensor", Type: "Type7E", Channels: [1, 2], Variables: [
        //             { Name: "Celsius", Type: "TempC", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "Fahrenheit", Type: "TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "Humidity", Type: "Humidity", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
        //             //                {Name: "Pressure In Hg", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
        //             //                {Name: "Pressure Millibars", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
        //             //                {Name: "Dew Point C", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
        //             //                {Name: "Dew Point F", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
        //             //                {Name: "Heat Index C", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
        //             //                {Name: "Heat Index F", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]}
        //         ]
        //     },

        //     {
        //         Name: "4 - 20 ma Module Inputs", Type: "TypeFE_IN", Channels: [1, 2, 3, 4], Variables: [
        //             { Name: "Raw Value", Type: "Raw", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "0 - 20 ma Scaled", Type: "Scaled020", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "4 - 20 ma Scaled", Type: "Scaled420", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
        //         ]
        //     },

        //     {
        //         Name: "4 - 20 ma Module Outputs", Type: "TypeFE_OUT", Channels: [1, 2], Variables: [
        //             { Name: "Raw Value", Type: "Raw", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "4 - 20 ma Scaled", Type: "Scaled420", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
        //         ]
        //     },

        //     {
        //         Name: "10 volt Module Inputs", Type: "TypeFD_IN", Channels: [1, 2, 3, 4], Variables: [
        //             { Name: "Raw Value", Type: "RawIn", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "-10 - 10 volt Scaled", Type: "ScaledIn", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
        //         ]
        //     },

        //     {
        //         Name: "10 volt Module Outputs", Type: "TypeFD_OUT", Channels: [1, 2], Variables: [
        //             { Name: "Raw Value", Type: "RawOut", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
        //             { Name: "10 - 10 volt Scaled", Type: "ScaledOut", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
        //         ]
        //     }
        // ];



        _this.getHtmlSafe = function (content) {
            if (content) {
                var safeHtml = content.replaceAll('\n', '<br>');
                return $sce.trustAsHtml(safeHtml);
            }
        };


        _this.getHtmlSafeActions = function (signal) {
            if (signal.Actions) {
                var safeHtml = signal.Actions.replaceAll('\n', '<br>');
                return $sce.trustAsHtml(safeHtml);
            }
        };



        _this.hasChanged = function (config, savedConfig) {
            var hasChanged = !angular.equals(_this.Config, _this.SavedConfig);
            return hasChanged;

            var changed = false;
            if (_this.CurrentService && null != _this.CurrentService) {
                changed = _this.CurrentService.hasChanged();
            }
            return changed;
        };



        _this.schemaUpdated = function (file) {
            var fileSchemaArray = file.Schema.split(',');
            file.Schema = fileSchemaArray;
        };



        _this.saveChangesRequest = function () {
            // lets validate the form before saving
            var valid = true;
            if (_this.CurrentService && null != _this.CurrentService) {
                valid = _this.CurrentService.validate();
            }

            if (valid) {
                _this.SaveDialog = bootbox.confirm({
                    title: "Are you sure you want to save your changes?",
                    message: "Your changes will take affect without needing to reboot.",
                    buttons: {
                        cancel: {
                            label: 'Cancel',
                            className: 'btn-default'
                        },
                        confirm: {
                            label: 'Save',
                            className: 'btn-success'
                        }
                    },
                    callback: function (result) {
                        if (result) {
                            TaskService.TasksLoaded = false;
                            $scope.$apply();
                            _this.saveChanges();
                            return false;
                        }
                    }
                });
                _this.SaveDialog.init(function () {
                    $(".modal-header").css("background-color", "#5cb85c");
                    $(".modal-header").css("color", "#fff");
                    $("#bootbox-confirm-btn").prop('disabled', false);
                    $("#bootbox-cancel-btn").prop('disabled', false);
                });

            } else {
                bootbox.alert({
                    title: 'Validation Error',
                    message: 'There was an error during validation.  Please check the fields in red and try again'
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4e");
                    $(".modal-header").css("color", "#fff");
                });
            }

        };



        _this.saveAsChangesRequest = function () {
            // lets validate the form before saving
            var valid = true;
            if (_this.CurrentService && null != _this.CurrentService) {
                valid = _this.CurrentService.validate();
            }

            if (valid) {
                _this.SaveDialog = bootbox.prompt({
                    title: "Please enter the new name for the workspace",
                    // message: "Your changes will take affect without needing to reboot.",
                    buttons: {
                        cancel: {
                            label: 'Cancel',
                            className: 'btn-default'
                        },
                        confirm: {
                            label: 'Save',
                            className: 'btn-success'
                        }
                    },
                    value: _this.Workspace.replaceAll('.json', ''),
                    callback: function (result) {
                        if (result) {
                            if (!result.endsWith('.json')) {
                                result += '.json';
                            }
                            _this.Workspace = result;
                            TaskService.TasksLoaded = false;
                            $scope.$apply();
                            _this.saveChanges();

                            // update the url to contain the new workspace name
                            $location.search('workspace', result);

                            return false;
                        }
                    }
                });
                _this.SaveDialog.init(function () {
                    $(".modal-header").css("background-color", "#5cb85c");
                    $(".modal-header").css("color", "#fff");
                    $("#bootbox-confirm-btn").prop('disabled', false);
                    $("#bootbox-cancel-btn").prop('disabled', false);
                    $(".bootbox-input").keyup(function () {
                        this.value = this.value.replace(/ /g, "_");
                    });
                });

            } else {
                bootbox.alert({
                    title: 'Validation Error',
                    message: 'There was an error during validation.  Please check the fields in red and try again'
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4e");
                    $(".modal-header").css("color", "#fff");
                });
            }

        };



        _this.saveComplete = function () {
            if (null !== _this.SaveDialog) {
                _this.SaveDialog.modal('hide');
                _this.SaveDialog = null;
            }

            // make sure to get the updated workspace files with this new filename
            _this.getWorkspaceFiles();

            _this.SavedConfig = angular.copy(_this.Config);
            $scope.$apply();

            JnrWebsocket.postMessage(2010, { Message: 'config.updated' });
        };



        _this.saveChanges = function () {
            if (null != _this.Workspace && '' != _this.Workspace) {
                $("#bootbox-confirm-btn").html("Saving...");
                $("#bootbox-confirm-btn").prop('disabled', true);
                $("#bootbox-cancel-btn").prop('disabled', true);

                _this.save(_this.saveComplete);

            } else {
                _this.saveAsChangesRequest();
            }
        };



        _this.save = function (saveCompleteCallback) {
            // write the saved config to a backup file
            var workspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;

            var bakFileContent = _this.getJson(_this.SavedConfig);
            JnrWebsocket.writeFile(workspaceFileName + '.bak', bakFileContent);

            var fileContent = _this.getJson();
            JnrWebsocket.writeFile(workspaceFileName, fileContent, saveCompleteCallback);
        };



        _this.cancelChangesRequest = function () {
            _this.CancelDialog = bootbox.confirm({
                title: "Are you sure you want to cancel your changes?",
                message: "Cancelling your changes will reload the last saved settings",
                buttons: {
                    cancel: {
                        label: 'Keep Changes',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Discard Changes',
                        className: 'btn-warning'
                    }
                },
                callback: function (result) {
                    if (result) {
                        _this.cancelChanges();
                        return false;
                    }
                }
            });
            _this.CancelDialog.init(function () {
                $(".modal-header").css("background-color", "#f0ad4e");
                $(".modal-header").css("color", "#fff");
                $("#bootbox-confirm-btn").prop('disabled', false);
                $("#bootbox-cancel-btn").prop('disabled', false);
            });
        };



        _this.cancelComplete = function () {
            if (null !== _this.CancelDialog) {
                _this.CancelDialog.modal('hide');
                _this.CancelDialog = null;
            }

            _this.SavedConfig = angular.copy(_this.Config);
            $scope.$apply();
        };



        _this.cancelChanges = function () {
            $("#bootbox-confirm-btn").html("Reverting...");
            $("#bootbox-confirm-btn").prop('disabled', true);
            $("#bootbox-cancel-btn").prop('disabled', true);

            _this.load(_this.cancelComplete);
        };



        _this.restoreRequest = function () {
            _this.RestoreDialog = bootbox.confirm({
                className: 'bb-primary',
                title: "Are you sure you want to restore the backup version of the " + _this.Workspace + " workspace?",
                // message: '<p>This dialog will present all of the bakup files.  It will show you the ' +
                //     'last modified time and if there is a newer version of the file in progress.  ' +
                //     'You can select a file to have it restored to a non backed up version</p>' +
                //     '<table class="table"><tr><th></th><th>File Name</th><th>Last Modified</th></tr>' +
                //     '<tr><td><input type="checkbox"></td><td>File 1</td><td>Apr 16 2019 16:08</td></tr></table>' +
                //     '<tr><td><input type="checkbox"></td><td>File 2</td><td>Apr 16 2019 16:08</td></tr></table>' +
                //     '<tr><td><input type="checkbox"></td><td>File 3</td><td>Apr 16 2019 16:08</td></tr></table>' +
                //     '<p class="alert alert-danger">This feature is not yet implemented</p>',
                message: '<p>Are you sure you want to restore the backup version of the <b>' + _this.Workspace + '</b> workspace?</p>' +
                    '<p>The previous version of this file was last modified on <b>Apr 16 2019 16:08</b></p>' +
                    '<p class="alert alert-danger">This feature is not yet implemented</p>',
                buttons: {
                    cancel: {
                        label: 'Nevermind',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Restore the Workspace',
                        className: 'btn-primary'
                    }
                },
                callback: function (result) {
                    if (result) {
                        // return false;
                    }
                }
            });
            _this.RestoreDialog.init(function () {
                $("#bootbox-confirm-btn").prop('disabled', true);
                $("#bootbox-cancel-btn").prop('disabled', false);
            });
        };



        _this.deleteRequest = function () {
            _this.DeleteDialog = bootbox.confirm({
                className: 'bb-primary',
                title: "Are you sure you want to delete the " + _this.Workspace + " workspace?",
                message: '<p>Are you sure you want to delete the <b>' + _this.Workspace + '</b> workspace?</p>' +
                    '<p>Deleting the workspace will make a backup copy of the workspace and ' +
                    'delete the current version.  This will prevent the workspace logic from ' +
                    'running and allow you to restore if you change your mind later.<p>',
                buttons: {
                    cancel: {
                        label: 'Ah! Nevermind',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Delete the Workspace',
                        className: 'btn-primary'
                    }
                },
                callback: function (result) {
                    if (result) {
                        // write the saved config to a backup file
                        var workspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;

                        var bakFileContent = _this.getJson(_this.SavedConfig);
                        JnrWebsocket.writeFile(workspaceFileName + '.bak', bakFileContent);

                        // no delete the json file for this workspace
                        JnrWebsocket.removeFile(workspaceFileName).then(function () {
                            _this.getWorkspaceFiles();

                            bootbox.alert({
                                className: 'bb-primary',
                                title: 'Workspace Removed!',
                                message: '<p><b>' + _this.Workspace + '</b> has been deleted!</p><p>But ' +
                                    'dont worry.  A <b>backup</b> has been created for you to ' +
                                    '<b>resotre</b> from later!</p>'
                            });

                            _this.close();
                        });
                    }
                }
            });
        };



        _this.showPreferences = function () {
            var template = '<div ng-include="\'preferences.html\'"></div>';
            var linkFn = $compile(template);
            var html = linkFn($scope);

            bootbox.dialog({
                className: 'bb-primary',
                title: "Preferences",
                message: html,
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Set',
                        className: 'btn-success',
                        callback: function (result) {
                            if (result) {
                                var form = $("#preferences-form");
                                form.validate({ errorPlacement: function (error, element) { } });

                                if (form.valid()) {
                                    // if (undefined == schedule.Params) schedule.Params = {};
                                    // if (undefined == schedule.Params.Rules) schedule.Params.Rules = [];
                                    // schedule.Params.Rules.push(_this.SelectedRule);

                                    // $scope.$apply();
                                } // else return false;
                            }
                        }
                    }
                }
            });
        };



        ///////////////////////////////////////////////////////



        _this.fileNameChange = function (filename) {
            if (filename) {
                alert(filename);
            }
        };


        _this.environConfigLastModified = null;

        var lastFocused;
        _this.setLastFocused = function ($event) {
            if (!$event) {
                lastFocused = null;
            } else if (lastFocused !== $event.currentTarget) {
                lastFocused = $event.currentTarget;
            }
        };

        _this.shouldInsertType = function () {
            return lastFocused && (null !== lastFocused);
        };

        _this.isModulePresent = function (signal) {
            var moduleId = null;
            for (var deviceIndex in _this.Devices) {
                if (_this.Devices[deviceIndex].Type === signal.Type) {
                    moduleId = _this.Devices[deviceIndex].Id;
                }
            }

            var modulePresent = false;
            if (null !== moduleId) {
                modulePresent = _this.knownDevices[moduleId];
            }

            return modulePresent;
        };

        _this.insertText = function (text) {
            insertText(lastFocused, text);
        };
    });


var fileNameTarget = null;
var fileNameScope = null;

TaskerApp.directive('filenameChange', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keyup", function (event) {
            var target = event.target;
            console.log("keyup: " + event.which);
            console.log("scope " + scope);
            // did the user press '{'
            if (event.which === 219) {
                var selectionStart = target.selectionStart;
                console.log("selectionStart: " + selectionStart);
                if (1 < selectionStart) {
                    // check to see if the typed character and the previous character make "{{"
                    var value = target.value;
                    console.log("value: " + value);
                    var substr = value.substring(selectionStart - 2, selectionStart);
                    console.log("substr: " + substr);
                    if ("{{" === substr) {
                        fileNameTarget = target;
                        fileNameScope = scope;
                        showFileNameOptions();
                    }
                }

            } else if ("keydown" === event.type && event.which === 112) {

                var selectionStart = target.selectionStart;
                console.log("selectionStart: " + selectionStart);
                var prevLeftCurlyBrace = target.value.lastIndexOf("{{", selectionStart);
                console.log("prevLeftCurlyBrace: " + prevLeftCurlyBrace);
                var prevRightCurlyBrace = target.value.lastIndexOf("}}", selectionStart);
                console.log("prevRightCurlyBrace: " + prevRightCurlyBrace);
                var nextLeftCurlyBrace = target.value.indexOf("{{", selectionStart);
                console.log("nextLeftCurlyBrace: " + nextLeftCurlyBrace);
                var nextRightCurlyBrace = target.value.indexOf("}}", selectionStart);
                console.log("nextRightCurlyBrace: " + nextRightCurlyBrace);

                if ((prevLeftCurlyBrace > prevRightCurlyBrace) && -1 !== nextRightCurlyBrace && (-1 === nextLeftCurlyBrace || nextRightCurlyBrace < nextLeftCurlyBrace)) {
                    fileNameTarget = target;
                    fileNameScope = scope;
                    showFileNameOptions();
                }

                event.preventDefault();
            }
        });
    };
});



TaskerApp.service('WorkspaceFileService', function ($location) {
    var _service = this;

    _service.uploadFile = function (file) {
        if (file) {
            if (file.size > 102400) {
                bootbox.alert("Selected file is too large");
                return;
            }

            bootbox.confirm({
                className: 'bb-primary',
                title: "Are you sure you want to load the selected file?",
                message: "Are you sure you want to upload the '" + file.name + "' workspace?",
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-primary'
                    }
                },
                callback: function (result) {
                    if (result) {
                        var r = new FileReader();
                        r.onload = function (e) {
                            var contents = e.target.result;

                            try {
                                // make sure the filename does not contain spaces
                                var filename = file.name.replaceAll(' ', '_');
                                var fullname = "/flash/tasker/workspaces/" + filename;

                                JnrWebsocket.writeFile(fullname, contents, function () {
                                    bootbox.alert({
                                        className: 'bb-success',
                                        title: 'Upload Success!',
                                        message: file.name + " uploaded as " + fullname
                                    });

                                    $location.search('workspace', file.name);
                                });

                                // also alert out java application that the new file should be ready to consume.
                                JnrWebsocket.postMessage(2010, { Message: 'config.updated' });
                            } catch (e) {
                                alert("Failed uploading the file" + e.toString());
                                return false;
                            }
                            return true;
                        };
                        r.readAsText(file);
                    }
                }
            });
        }
    };


    // _service.downloadFile = function (filename) {
    //     JnrWebsocket.downloadFile(filename).then(function (fileReadJson) {
    //         var workspaceFileDownload = document.getElementById("part-file-download");
    //         workspaceFileDownload.innerHTML = "<a id='download-link' href='" + fileReadJson.Meta + "' target='_blank' download>download</a>";
    //         var downloadLink = document.getElementById("download-link");
    //         downloadLink.click();
    //     });
    // };
}
);