/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceFactory;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.Json;

public class DeviceConfiguration {
    private final WorkspaceFile _workspaceConfigurationFile;
    private final DeviceCollection _deviceCollection = new DeviceCollection();

    public DeviceConfiguration(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public DeviceCollection getDeviceCollection() {
        return this._deviceCollection;
    }

    public void loadConfiguration(Json[] deviceListJsonArray) throws Throwable {
        if (null == deviceListJsonArray || 0 == deviceListJsonArray.length) {
            return;
        }
        this._deviceCollection.clear();
        for (Json deviceJson : deviceListJsonArray) {
            DeviceProfile device = DeviceFactory.getDevice(deviceJson);
            this._deviceCollection.put(device);
        }
    }
}

