/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.io.AppLog;

public class TextReplacer {
    public static String replace(String text, Scope scope) {
        String newText = TextReplacer.replace(text, scope, "null");
        while (!newText.equals(text)) {
            text = newText;
            newText = TextReplacer.replace(text, scope, "null");
        }
        return newText;
    }

    public static String replace(String text, Scope scope, String errorValueString) {
        boolean _debug_ = scope.isDebug();
        if (_debug_) {
            System.out.println(String.format("text replacer: %s", text));
        }
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (text.length() > lastIndex) {
            int doubleLeftBracketPos;
            if (_debug_) {
                System.out.println("text remaining: " + text.substring(lastIndex));
            }
            if (-1 == (doubleLeftBracketPos = text.indexOf("{{", lastIndex))) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            int doubleRightBracketPos = text.indexOf("}}", doubleLeftBracketPos);
            if (-1 == doubleRightBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            if (doubleLeftBracketPos != lastIndex) {
                sb.append(text.substring(lastIndex, doubleLeftBracketPos));
            }
            String bindObjectString = text.substring(doubleLeftBracketPos + 2, doubleRightBracketPos);
            if (_debug_) {
                System.out.println("bindObjectString: " + bindObjectString);
            }
            if (_debug_) {
                System.out.println("scope.contains(" + bindObjectString + "): " + scope.contains(bindObjectString));
            }
            if (scope.contains(bindObjectString)) {
                Object variable = scope.getVariable(bindObjectString);
                sb.append(variable);
            } else {
                try {
                    Object newValue;
                    ExpressionEngine _expressionEngine = new ExpressionEngine();
                    _expressionEngine.parse(bindObjectString);
                    Object resultObject = _expressionEngine.execute(scope);
                    if (_debug_) {
                        System.out.println("resultObject = " + resultObject);
                    }
                    String resultObjectString = String.valueOf(resultObject);
                    if (_debug_) {
                        System.out.println("resultObjectString = " + resultObjectString);
                    }
                    if (null != (newValue = resultObject)) {
                        if (newValue instanceof Double) {
                            sb.append(String.format("%.2f", newValue));
                        } else {
                            sb.append(newValue);
                        }
                    } else {
                        sb.append(errorValueString);
                    }
                }
                catch (DeviceNotPresentException ex) {
                    AppLog.error(ex.getMessage());
                    throw new RuntimeException(String.format("error evaluating %s in text replacer", text), ex);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("error evaluating %s in text replacer", text), ex);
                }
            }
            lastIndex = doubleRightBracketPos + 2;
        }
        return sb.toString();
    }
}

