/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.text.DecimalFormat;

public class TenVoltOutputObject
extends AbstractObjectCall {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");
    private static final int CHANNELS_PER_MODULE = 2;
    private AbstractNode _channelNode;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            parser.nextToken();
            parser.expect("[");
            if (!parser.currentToken().checkType(3) && !parser.currentToken().checkType(0)) {
                throw new UnexpectedTokenException("NUMBER | IDENTIFIER", parser.currentToken());
            }
            this._channelNode = parser.parseExpression();
            System.out.println("_channelNode = " + this._channelNode);
            parser.expect("]");
            parser.expect(".");
            if (!parser.currentToken().checkType(0)) {
                throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
            }
            this._fieldOrMethodName = parser.eatToken().content;
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process four twenty input object", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        int channel = (Integer)this._channelNode.execute(scope);
        return TenVoltOutputObject.read(channel, this._fieldOrMethodName);
    }

    public static Object read(int channel, String fieldName) {
        block6: {
            try {
                int moduleIndex = (channel - 1) / 2;
                TypeFD typeFd = TypeFD.getByIndex(moduleIndex);
                if (null != typeFd) {
                    String presentDevicesString = JANOS.getRegistryString((String)"externals/$present", (String)"");
                    if (!presentDevicesString.contains(typeFd.AddressString)) {
                        throw new DeviceNotPresentException(String.format("TypeFD_%d is not present", moduleIndex + 1));
                    }
                    try {
                        typeFd.read();
                        int localChannel = (channel - 1) % 2 + 1;
                        fieldName = String.format("%sout_%d", fieldName, localChannel);
                        Object value = typeFd.get(fieldName);
                        return value;
                    }
                    catch (IOException ex) {
                        AppLog.error(String.format("error getting 10v %s for output channel %d", fieldName, channel), ex);
                        break block6;
                    }
                }
                throw new DeviceNotPresentException(String.format("TypeFD_%d is not present", moduleIndex + 1));
            }
            catch (IOException ex) {
                throw new RuntimeException("error reading 4-20 output", ex);
            }
        }
        return Double.NaN;
    }
}

