/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker.ast;

import com.integ.tasker.identifierobjects.IdentifierObject;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;
import java.util.ArrayList;

public class ASTVariableNode
implements ASTNode {
    private final String _variableString;
    private IdentifierObject _identifierObject = null;

    public ASTVariableNode(String variableString) {
        System.out.println("new variable: " + variableString);
        this._variableString = variableString;
    }

    @Override
    public Object evaluate() {
        try {
            if (ASTParser.isDebug()) {
                System.out.println("ASTVariableNode.evaluate: " + this._variableString);
            }
            if (null == this._identifierObject) {
                Queue<Token> tokenQueue = new Queue<Token>();
                Lexer.parse(tokenQueue, this._variableString);
                TokenStream tokens = new TokenStream(tokenQueue);
                tokens.printDebug(true);
                Token currentToken = tokens.getCurrent();
                if (!currentToken.checkType(0)) {
                    throw new RuntimeException("device identifier expected.  found " + currentToken + " instead");
                }
                String identifierNameString = currentToken.content;
                System.out.println("identifierNameString: " + identifierNameString);
                this._identifierObject = IdentifierObject.getIdentifierObject(identifierNameString);
                if (null == this._identifierObject) {
                    throw new RuntimeException("unknown identifier object for " + identifierNameString);
                }
                currentToken = tokens.nextToken();
                if (currentToken.checkType(91)) {
                    currentToken = tokens.nextToken();
                    if (!currentToken.checkType(3)) {
                        throw new RuntimeException("channel expected.  found " + currentToken + " instead");
                    }
                    int channel = Integer.parseInt(currentToken.content);
                    this._identifierObject.setChannel(channel);
                    currentToken = tokens.nextToken();
                    if (!currentToken.checkType(93)) {
                        throw new RuntimeException("']' expected.  found " + currentToken + " instead");
                    }
                    currentToken = tokens.nextToken();
                }
                String fieldOrMethod = "";
                if (currentToken.checkType(46)) {
                    currentToken = tokens.nextToken();
                    fieldOrMethod = currentToken.content;
                    if (!tokens.isEmpty()) {
                        currentToken = tokens.nextToken();
                    }
                }
                if (!tokens.isEmpty()) {
                    if (currentToken.checkType(40)) {
                        System.out.println("parens: " + currentToken);
                        Object[] paramsArray = new String[]{};
                        if (!currentToken.checkType(41)) {
                            ArrayList<String> paramsList = new ArrayList<String>();
                            while (!currentToken.checkType(41)) {
                                System.out.println("  param arg: " + currentToken);
                                paramsList.add(currentToken.content);
                                currentToken = tokens.nextToken();
                            }
                            System.out.println("params: " + StringUtils.join(paramsList.toArray(), ",  "));
                            paramsArray = (String[])paramsList.toArray();
                        }
                        this._identifierObject.setMethod(fieldOrMethod, paramsArray);
                    } else {
                        this._identifierObject.setField(fieldOrMethod);
                    }
                } else {
                    this._identifierObject.setField(fieldOrMethod);
                }
            }
            return this._identifierObject.evaluate();
        }
        catch (Exception ex) {
            AppLog.error(ex);
            return Double.NaN;
        }
    }

    public String toString() {
        String retString = "{{ " + this._variableString + "=" + this.evaluate() + " }}";
        return retString;
    }
}

