/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.ActionFactory;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

public abstract class Action {
    protected final Task _parentTask;
    protected final Json _json;
    protected final Json _paramsJson;
    protected String _methodString;

    protected Action(Task parentTask, Json json) {
        this._parentTask = parentTask;
        this._json = json;
        this._paramsJson = (Json)json.get("Params");
    }

    public abstract void execute(TaskRuntime var1) throws Throwable;

    public Action[] getActions(String actionsName) {
        Action[] actions;
        if (null != this._paramsJson.get(actionsName)) {
            Json[] actionsJson = (Json[])this._paramsJson.get(actionsName);
            actions = new Action[actionsJson.length];
            System.out.println(String.format("%d actions", actions.length));
            for (int i = 0; i < actions.length; ++i) {
                Json actionJson = actionsJson[i];
                try {
                    actions[i] = ActionFactory.getActionClass(this._parentTask, actionJson);
                    System.out.println(String.format("actions[i]: %s", actions[i].toString()));
                    continue;
                }
                catch (Throwable ex) {
                    Throwable throwable = new Exception("error loading action").initCause(ex);
                    AppLog.error(throwable);
                    ErrorMessage message = new ErrorMessage(ex.getMessage());
                    MessagePumpEngine.postMessage(message.build());
                }
            }
        } else {
            actions = new Action[]{};
        }
        return actions;
    }

    protected int getIntParam(String name, TaskRuntime taskRuntime) {
        int result = Integer.MIN_VALUE;
        try {
            Object value;
            if (this._paramsJson.containsKey(name) && null != (value = this._paramsJson.get(name))) {
                if (value instanceof String) {
                    String variableName = (String)value;
                    if (variableName.startsWith("$")) {
                        value = taskRuntime.Scope.getVariable(variableName);
                        result = Integer.parseInt(value.toString());
                    } else if (variableName.startsWith("\\x") || variableName.startsWith("0x")) {
                        value = variableName.substring(2);
                        result = Integer.parseInt(value.toString(), 16);
                    } else {
                        result = Integer.parseInt(value.toString());
                    }
                } else {
                    result = Integer.parseInt(value.toString());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error getting %s parameter: %s", name, ex.getMessage()));
        }
        return result;
    }

    protected double getDoubleParam(String name, TaskRuntime taskRuntime) {
        double result = Double.MIN_VALUE;
        try {
            Object value;
            if (this._paramsJson.containsKey(name) && null != (value = this._paramsJson.get(name))) {
                String variableName;
                if (value instanceof String && (variableName = (String)value).startsWith("$")) {
                    value = taskRuntime.Scope.getVariable(variableName);
                }
                result = Double.valueOf(value.toString());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error getting %s parameter: %s", name, ex.getMessage()));
        }
        return result;
    }

    protected String getStringParam(String name, TaskRuntime taskRuntime) {
        try {
            if (this._paramsJson.containsKey(name)) {
                Object value = this._paramsJson.get(name);
                return String.valueOf(value);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error getting %s parameter: %s", name, ex.getMessage()));
        }
        return null;
    }

    public String toString() {
        return String.format("%s", this.getClass().getName());
    }
}

