/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.tasks.actions.ActionFactory;
import com.integ.tasker.webhandlers.ErrorMessage;
import java.util.Json;

public class Task {
    public String Name;
    private final TaskConfiguration _taskConfiguration;
    private boolean _enabled;
    private Action _baseAction;

    public Task(TaskConfiguration taskConfiguration) {
        this._taskConfiguration = taskConfiguration;
    }

    public TaskConfiguration getTaskConfiguration() {
        return this._taskConfiguration;
    }

    public void load(Json taskJson) {
        try {
            Action baseAction;
            this.Name = taskJson.getString("Name");
            TaskConfiguration.LOG.info("loading task: " + this.Name);
            this._enabled = taskJson.getBoolean("Enabled");
            TaskConfiguration.LOG.info("enabled: " + this._enabled);
            Json baseActionJson = (Json)taskJson.get("Action");
            this._baseAction = baseAction = ActionFactory.getActionClass(this, baseActionJson);
            System.out.println(String.format("BaseAction: %s", this._baseAction.toString()));
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            TaskConfiguration.LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public void execute() throws Throwable {
        if (this._enabled) {
            TaskRuntime taskRuntime = new TaskRuntime();
            try {
                TaskConfiguration.LOG.info("execute " + this.Name);
                if (null == this._baseAction) {
                    throw new RuntimeException("Base action is null");
                }
                this._baseAction.execute(taskRuntime);
            }
            catch (Throwable ex) {
                throw new Exception("error executing task: " + this.Name).initCause(ex);
            }
        }
    }
}

