/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.logger;

import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.loggers.LogProfile;
import com.integ.tasker.signals.SignalValueReplacer;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.tasker.ExpressionReplacer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Json;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogProfileMethod
extends Action {
    private static final Logger FILE_RETENTION_LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_file_retention.log").setLogType(LogTypes.SingleBak).setMaxFileSizeInKb(64));
    private static final QuickDateFormat SIMPLE_DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    private final String _logProfileName = this._paramsJson.getString("ProfileName");
    private LogProfile _logProfile;
    private File _parentDirectory;
    private String _compiledName = "";
    private boolean _nullEntryCreated = false;

    public LogProfileMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            System.out.println("Log to " + this._logProfileName);
            TaskConfiguration taskConfiguration = this._parentTask.getTaskConfiguration();
            WorkspaceConfigurationFile workspaceConfigurationFile = taskConfiguration.getWorkspaceConfigurationFile();
            this._logProfile = workspaceConfigurationFile.getLoggerProfileCollection().getByName(this._logProfileName);
            System.out.println("logProfile: " + this._logProfile);
            if (null != this._logProfile) {
                this.logEntry();
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing Log Profile: " + this._logProfileName).initCause(ex);
        }
    }

    private void nullEntry() {
        long start = System.currentTimeMillis();
        String filename = this.evaluateFilename();
        try {
            System.out.println("filename: " + filename);
            File file = new File(filename);
            this._parentDirectory = new File(file.getParent());
            System.out.println("parentDirectory.getPath(): " + this._parentDirectory.getPath());
            System.out.println("parentDirectory.exists(): " + this._parentDirectory.exists());
            if (!this._parentDirectory.exists()) {
                System.out.println("Create directory for " + this._parentDirectory.getPath());
                this._parentDirectory.mkdir();
            }
            String nullEntry = this._logProfile.Schema;
            while (-1 != nullEntry.indexOf("{{")) {
                nullEntry = nullEntry.substring(0, nullEntry.indexOf("{{")) + "null" + nullEntry.substring(nullEntry.indexOf("}}") + 2);
            }
            System.out.println("nullEntry: " + nullEntry);
            String line = SIMPLE_DATE_FORMAT.format(System.currentTimeMillis()) + ", " + nullEntry + "\r\n";
            FileUtils.appendAllBytes(filename, line.getBytes());
            if (!this._compiledName.equals(filename)) {
                this.newFileCreated();
                this._compiledName = filename;
            }
        }
        catch (Exception ex) {
            AppLog.error("error logging entry to " + filename, ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed: " + elapsed);
    }

    private void logEntry() {
        long start = System.currentTimeMillis();
        String filename = this.evaluateFilename();
        try {
            System.out.println("filename: " + filename);
            File file = new File(filename);
            this._parentDirectory = new File(file.getParent());
            System.out.println("parentDirectory.getPath(): " + this._parentDirectory.getPath());
            System.out.println("parentDirectory.exists(): " + this._parentDirectory.exists());
            if (!this._parentDirectory.exists()) {
                System.out.println("Create directory for " + this._parentDirectory.getPath());
                this._parentDirectory.mkdir();
            }
            if (!this._nullEntryCreated) {
                this.nullEntry();
                this._nullEntryCreated = true;
            }
            String line = SIMPLE_DATE_FORMAT.format(System.currentTimeMillis()) + ", ";
            if (null != this._logProfile.Schema && !"".equals(this._logProfile.Schema)) {
                SignalValueReplacer signalValueReplacer = new SignalValueReplacer(this._logProfile.Schema);
                String schemaResult = signalValueReplacer.evaluate();
                System.out.println("schemaResult: " + schemaResult);
                line = line + schemaResult + "\r\n";
            }
            System.out.println("line: " + line);
            FileUtils.appendAllBytes(filename, line.getBytes());
            if (!this._compiledName.equals(filename)) {
                this.newFileCreated();
                this._compiledName = filename;
            }
        }
        catch (Exception ex) {
            AppLog.error("error logging entry to " + filename, ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed: " + elapsed);
    }

    private String evaluateFilename() {
        String filename = this._logProfile.FileName;
        ExpressionReplacer expressionReplacer = new ExpressionReplacer(filename){

            @Override
            public String replace(String replaceString) {
                System.out.println("replace called: " + replaceString);
                Pattern pattern = Pattern.compile("date\\((\\w+)\\)");
                Matcher matcher = pattern.matcher(replaceString);
                if (matcher.find()) {
                    QuickDateFormat qdf = new QuickDateFormat(matcher.group(1));
                    return qdf.format(System.currentTimeMillis());
                }
                return "";
            }
        };
        return expressionReplacer.evaluate();
    }

    private void newFileCreated() {
        FILE_RETENTION_LOG.info("LogProfileMethod perform file retention logic");
        FILE_RETENTION_LOG.info("_filenameFormat: " + this._logProfile.FileName);
        FILE_RETENTION_LOG.info("_fileRetentionCount: " + this._logProfile.FilesToRetain);
        String filenameFormat = this._logProfile.FileName;
        FILE_RETENTION_LOG.info("filenameFormat: " + filenameFormat);
        while (-1 != filenameFormat.indexOf("{{")) {
            int endOfReplacer = filenameFormat.indexOf("}}");
            filenameFormat = -1 != filenameFormat.indexOf("{{date(") ? filenameFormat.substring(0, filenameFormat.indexOf("{{")) + this.getDateReplacer(filenameFormat, endOfReplacer) + filenameFormat.substring(endOfReplacer + 2) : filenameFormat.substring(0, filenameFormat.indexOf("{{")) + ".*" + filenameFormat.substring(endOfReplacer + 2);
            FILE_RETENTION_LOG.info("filenameFormat: " + filenameFormat);
        }
        final Pattern pattern = Pattern.compile(filenameFormat);
        String[] files = this._parentDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                try {
                    String fullFilename = dir + "/" + name;
                    Matcher matcher = pattern.matcher(fullFilename);
                    boolean accept = matcher.find();
                    FILE_RETENTION_LOG.info("accept? " + fullFilename + "  " + accept);
                    return accept;
                }
                catch (Exception ex) {
                    FILE_RETENTION_LOG.error(ex);
                    return false;
                }
            }
        });
        FILE_RETENTION_LOG.info("files.length: " + files.length);
        for (int i = files.length - this._logProfile.FilesToRetain - 1; i >= 0; --i) {
            FILE_RETENTION_LOG.info("remove files[" + i + "]");
            String filenameString = files[i];
            String fullFilename = this._parentDirectory.getPath() + "/" + filenameString;
            File file = new File(fullFilename);
            if (!file.delete()) continue;
            FILE_RETENTION_LOG.info(" removed " + fullFilename);
        }
    }

    private String getDateReplacer(String filenameFormat, int endOfReplacer) {
        String replacer = "";
        for (int i = filenameFormat.indexOf("{{date(") + 7; i < endOfReplacer - 1; i += 2) {
            if (i == filenameFormat.indexOf("MM")) {
                replacer = replacer + "((0[0-9])|(1[0-2]))";
                continue;
            }
            if (i == filenameFormat.indexOf("DD") || i == filenameFormat.indexOf("dd")) {
                replacer = replacer + "[0-3][0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("YYYY") || i == filenameFormat.indexOf("yyyy")) {
                replacer = replacer + "20[0-2][0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("YY") || i == filenameFormat.indexOf("yy")) {
                replacer = replacer + "[0-2][0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("HH")) {
                replacer = replacer + "([0-1][0-9])|(2[0-3])";
                continue;
            }
            if (i == filenameFormat.indexOf("hh")) {
                replacer = replacer + "(0[1-9])|(1[0-2])";
                continue;
            }
            if (i == filenameFormat.indexOf("mm")) {
                replacer = replacer + "[0-5][0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("ss")) {
                replacer = replacer + "[0-5][0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("f") || i == filenameFormat.indexOf("S")) {
                replacer = replacer + "[0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("f") || i == filenameFormat.indexOf("S")) {
                replacer = replacer + "[0-9]";
                continue;
            }
            if (i == filenameFormat.indexOf("zzz")) {
                replacer = replacer + "[a-z]|[A-Z]";
                continue;
            }
            if (i == filenameFormat.indexOf("aa")) {
                replacer = replacer + "am|pm";
                continue;
            }
            char c = filenameFormat.charAt(i);
            replacer = replacer + c;
            --i;
        }
        return replacer;
    }
}

