/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import java.util.Json;

public class IfMethod
extends Action {
    private final String _conditional;
    private final Action[] _actions;

    public IfMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._conditional = this._paramsJson.getString("Conditional");
        this._actions = super.getActions("Actions");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            ExpressionEngine _expressionEngine = new ExpressionEngine();
            _expressionEngine.setDebug(_debug_);
            _expressionEngine.parse(this._conditional);
            Object resultObject = _expressionEngine.execute(taskRuntime.Scope);
            System.out.println("resultObject = " + resultObject);
            if (((Boolean)resultObject).booleanValue()) {
                this.executeActions(this._actions, taskRuntime);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing If Conditional: " + this._conditional).initCause(ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("if then elapsed: " + elapsed);
    }
}

