/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integ.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integ.janoslib.messagepump.MessagePumpAppHandler;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.scripting.ScriptTest;
import com.integ.tasker.AssemblyInfo;
import com.integ.tasker.Config;
import com.integ.tasker.FileSystemMonitor;
import com.integ.tasker.TaskerAsciiCommandSerialClient;
import com.integ.tasker.TaskerAsciiCommandServer;
import com.integ.tasker.schedules.ScheduleMonitor;
import com.integ.tasker.triggers.DigitalInputMonitor;
import com.integ.tasker.triggers.DigitalOutputMonitor;
import com.integ.tasker.web.handlers.AnnounceRequestHandler;
import com.integ.tasker.web.handlers.ConfigurationUpdatedHandler;
import com.integ.tasker.web.handlers.TaskExecuteHandler;
import com.integ.tasker.web.handlers.TasksGetHandler;
import com.integ.tasker.web.messages.AnnounceMessage;
import com.integ.tasker.web.messages.DeathMessage;
import com.integ.tasker.web.webrequest.GetLoadedTasksRequestHandler;
import com.integ.tasker.web.webrequest.GetTaskDevicesRequestHandler;
import com.integ.tasker.web.webrequest.TaskExecuteRequestHandler;
import com.integ.tasker.workspaces.WorkspaceDirectory;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.http.server.WebHandlerServer;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.ApplicationWatchdog;
import com.integpg.janoslib.system.DuplicateInstance;
import com.integpg.system.JANOS;

public class TaskerMain {
    public static final TaskerMain INSTANCE = new TaskerMain();
    public static final DigitalInputsIoLogMonitor DIGITAL_INPUTS_IO_LOG_MONITOR = new DigitalInputsIoLogMonitor();
    public static final DigitalInputMonitor DIGITAL_INPUT_MONITOR = new DigitalInputMonitor();
    public static final DigitalOutputsIoLogMonitor DIGITAL_OUTPUTS_IO_LOG_MONITOR = new DigitalOutputsIoLogMonitor();
    public static final DigitalOutputMonitor DIGITAL_OUTPUT_MONITOR = new DigitalOutputMonitor();
    private static final ApplicationWatchdog APPLICATION_WATCHDOG = new ApplicationWatchdog(0);
    private ControlPanel _controlPanel;

    public static void main(String[] args) throws InterruptedException {
        if (1 == args.length && "-scripttest".equalsIgnoreCase(args[0])) {
            try {
                ScriptTest.main(args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        Application.init(new AssemblyInfo());
        DuplicateInstance.exitOnDuplicateInstance();
        MessagePumpEngine.start();
        AnnounceMessage announceMessage = new AnnounceMessage();
        MessagePumpEngine.postMessage(announceMessage.build());
        INSTANCE.init();
        while (true) {
            try {
                while (true) {
                    APPLICATION_WATCHDOG.feed();
                    MessagePumpEngine.postMessage(announceMessage.build());
                    Thread.sleep(10000L);
                }
            }
            catch (Exception ex) {
                AppLog.error(ex);
                continue;
            }
            break;
        }
    }

    public static ControlPanel getControlPanel() {
        return TaskerMain.INSTANCE._controlPanel;
    }

    private void init() throws InterruptedException {
        Config.init();
        DIGITAL_INPUTS_IO_LOG_MONITOR.addIoChannelLogEventListener(DIGITAL_INPUT_MONITOR);
        DIGITAL_INPUTS_IO_LOG_MONITOR.start();
        DIGITAL_OUTPUTS_IO_LOG_MONITOR.addIoChannelLogEventListener(DIGITAL_OUTPUT_MONITOR);
        DIGITAL_OUTPUTS_IO_LOG_MONITOR.start();
        AppLog.info("add web page listener");
        MessagePumpAppHandler appListener = new MessagePumpAppHandler(2010).addCommandListener("announce.request", new AnnounceRequestHandler()).addCommandListener("tasks.get", new TasksGetHandler()).addCommandListener("task.execute", new TaskExecuteHandler()).addCommandListener("config.updated", new ConfigurationUpdatedHandler());
        MessagePumpEngine.addListener(appListener);
        this.initControlPanel();
        WorkspaceDirectory workspaceDirectory = new WorkspaceDirectory(Config.TASKER_WORKSPACE_DIRECTORY);
        TaskerAsciiCommandServer _asciiProtocol = new TaskerAsciiCommandServer();
        _asciiProtocol.start();
        TaskerAsciiCommandSerialClient.init();
        FileSystemMonitor.start();
        ScheduleMonitor.start();
        this.initWebServer();
    }

    private void initControlPanel() {
        System.out.println("init control panel");
        this._controlPanel = new ControlPanel();
    }

    private void initWebServer() {
        int port = Config.getWebServerPort();
        if (-1 != port) {
            WebHandlerServer webHandlerServer = new WebHandlerServer();
            webHandlerServer.addWebHandler("/executetask", new TaskExecuteRequestHandler());
            webHandlerServer.addWebHandler("/getloadedtasks", new GetLoadedTasksRequestHandler());
            webHandlerServer.addWebHandler("/gettaskdevices", new GetTaskDevicesRequestHandler());
            webHandlerServer.start(port);
        }
    }

    protected void finalize() {
        JANOS.syslog((String)"Tasker exiting...");
        DeathMessage deathMessage = new DeathMessage();
        MessagePumpEngine.postMessage(deathMessage.build());
    }
}

