/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.WorkspaceDirectory;
import com.integ.tasker.schedules.rules.OnBootRule;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integ.tasker.schedules.rules.ScheduleRuleFactory;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integ.tasker.webhandlers.StatusUpdateMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.ArrayList;
import java.util.Json;

public class Schedule {
    public static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_schedules.log").setMaxFileSizeInKb(32).setLogType(LogTypes.SingleBak));
    private final Json _json;
    private final WorkspaceConfigurationFile _parentConfigurationFile;
    private Json _paramsJson;
    public String Name;
    public String GUID;
    public String TaskName;
    private ArrayList<ScheduleRuleBase> _scheduleRules = new ArrayList();

    public Schedule(Json json, WorkspaceConfigurationFile parentConfigurationFile) {
        this._json = json;
        this._parentConfigurationFile = parentConfigurationFile;
        try {
            LOG.info("loading Schedule from " + json);
            this.Name = json.getString("Name");
            this.GUID = json.getString("GUID");
            this._paramsJson = (Json)this._json.get("Params");
            boolean enabled = this._paramsJson.getBoolean("Enabled");
            if (!enabled) {
                LOG.info(String.format("%s (%s) is not enabled", this.Name, this.GUID));
                return;
            }
            this.TaskName = this._paramsJson.getString("TaskName");
            LOG.info(String.format("schedule %s (%s) will execute %s", this.Name, this.GUID, this.TaskName));
            this.loadRules();
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    private void loadRules() {
        Json[] rulesJsonArray = (Json[])this._paramsJson.get("Rules");
        if (null != rulesJsonArray) {
            for (Json ruleJson : rulesJsonArray) {
                System.out.println("ruleJson: " + ruleJson);
                ScheduleRuleBase scheduleBase = ScheduleRuleFactory.getRule(this, ruleJson);
                if (scheduleBase instanceof OnBootRule && WorkspaceDirectory.IsInitialLoad()) {
                    this.execute();
                    continue;
                }
                this._scheduleRules.add(scheduleBase);
            }
        }
    }

    public ArrayList<ScheduleRuleBase> getScheduleRules() {
        return this._scheduleRules;
    }

    public void execute() {
        String description = String.format("%s execute %s", this.Name, this.TaskName);
        LOG.info(description);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Task task = TaskCollection.GLOBAL.getByTaskName(Schedule.this.TaskName);
                    if (null != task) {
                        StatusUpdateMessage message = new StatusUpdateMessage(String.format("Schedule %s is executing %s", Schedule.this.Name, Schedule.this.TaskName));
                        MessagePumpEngine.postMessage(message.build());
                        task.execute();
                        message = new StatusUpdateMessage(String.format("Schedule %s successfully executed %s", Schedule.this.Name, Schedule.this.TaskName));
                        MessagePumpEngine.postMessage(message.build());
                    }
                }
                catch (Throwable ex) {
                    AppLog.error(ex);
                    ErrorMessage message = new ErrorMessage(ex);
                    MessagePumpEngine.postMessage(message.build());
                }
            }
        }, description).start();
    }
}

