/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.logging.AppLog;

public class ControlPanelLedObject
extends AbstractObjectCall {
    private AbstractNode _channelNode;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        boolean shouldDebug = parser.shouldDebug();
        try {
            System.out.println("ControlPanelLedObject parser.currentToken() = " + parser.currentToken());
            parser.nextToken();
            if (!parser.currentToken().checkType(91)) {
                throw new UnexpectedTokenException("[", parser.currentToken());
            }
            parser.nextToken();
            if (!parser.currentToken().checkType(3)) {
                throw new UnexpectedTokenException("NUMBER", parser.currentToken());
            }
            this._channelNode = (ValueNode)parser.parseExpression();
            if (shouldDebug) {
                System.out.println("_channelNode = " + this._channelNode);
            }
            if (!parser.currentToken().checkType(93)) {
                throw new UnexpectedTokenException("]", parser.currentToken());
            }
            parser.nextToken();
            if (parser.currentToken().checkType(46)) {
                parser.nextToken();
                if (!parser.currentToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
                }
                this._fieldOrMethodName = parser.eatToken().content;
            }
        }
        catch (Exception ex) {
            parser.setDebug(shouldDebug);
            throw new ScriptParserException("unable to process control panel led", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = true;
        ControlPanel controlPanel = TaskerMain.getControlPanel();
        Object channelResult = this._channelNode.execute(scope);
        if (_debug_) {
            System.out.println("channelResult.getClass() = " + channelResult.getClass());
        }
        int channel = ((Number)channelResult).intValue();
        if (_debug_) {
            System.out.println("channel = " + channel);
        }
        if (0 == controlPanel.getPanelCount()) {
            AppLog.info("no control panels detected.  reenumerating now");
            controlPanel = TaskerMain.getControlPanel().enumeratePanels();
            controlPanel.monitorSwitches();
        }
        int leds = controlPanel.getLeds();
        if (_debug_) {
            System.out.println("leds = " + leds);
        }
        int ledState = leds >> channel - 1 & 1;
        if (_debug_) {
            System.out.println("ledState = " + ledState);
        }
        return ledState;
    }
}

