/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class Type28
extends ExternalModule {
    private double _tempC;
    private double _tempF;

    public static Type28 getByIndex(int index) throws IOException {
        return Type28.getByNumber(index + 1);
    }

    public static Type28 getByNumber(int number) throws IOException {
        String deviceAddressString = ExternalUtils.getDeviceAddressFor("28", number);
        if (!CACHED_DEVICES.containsKey(deviceAddressString)) {
            long address = HexUtils.parseHexAsLong(deviceAddressString);
            CACHED_DEVICES.put(deviceAddressString, new Type28(address, number));
        }
        return (Type28)CACHED_DEVICES.get(deviceAddressString);
    }

    public Type28(long address) {
        super(address, -1, "Type28");
    }

    public Type28(long address, int index) {
        super(address, index, "Type28");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResolution(int resolution) throws IOException {
        SensorPort sensorPort = SENSOR_PORT;
        synchronized (sensorPort) {
            byte[] config = new byte[4];
            config[0] = 78;
            config[3] = (byte)(31 + (resolution - 9 << 5));
            SENSOR_PORT.select(this.Address);
            SENSOR_PORT.data(config, 0, config.length);
        }
    }

    @Override
    public long getMinReadInterval() {
        return 1000L;
    }

    public double getTempC() {
        return this._tempC;
    }

    public double getTempF() {
        return this._tempF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws Throwable {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                this._hasChanged = false;
                SensorPort sensorPort = SENSOR_PORT;
                synchronized (sensorPort) {
                    this._dataBlock = SensorPort.readDeviceBlock((long)this.Address);
                    if (null == this._dataBlock || this._dataBlock.length != 8) {
                        throw new IOException("Unable to read " + this.AddressString);
                    }
                }
                this.LastReadTime = System.currentTimeMillis();
                if (this.checkForChange()) {
                    long longBits = ArrayUtils.getLong((byte[])this._dataBlock, (int)0);
                    System.out.println(String.format("   %3x", longBits));
                    this._tempC = Double.longBitsToDouble(longBits);
                    this._tempF = this._tempC * 9.0 / 5.0 + 32.0;
                }
                if (0 >= attempt) break;
                AppLog.warn("Type28 retry successful");
                break;
            }
            catch (IOException ex) {
                AppLog.warn("Error reading temperature module: " + ex.getMessage());
                continue;
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void printValues() {
    }

    public static Object get(int channel, String fieldName) {
        try {
            int index = channel - 1;
            Type28 device = Type28.getByIndex(index);
            if (null != device) {
                device.read();
                return device.get(fieldName);
            }
            throw new RuntimeException("Ten Volt Module not present for index " + index);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error getting value for Type28." + fieldName, ex);
        }
    }

    @Override
    public Object get(String fieldName) {
        if ("f".equalsIgnoreCase(fieldName) || "tempf".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName)) {
            return this.getTempF();
        }
        if ("c".equalsIgnoreCase(fieldName) || "tempc".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName)) {
            return this.getTempC();
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }

    @Override
    public String toString() {
        return String.format("   %s: %.3f C, %.3f F", this.AddressString, this.getTempC(), this.getTempF());
    }
}

