/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.TextReplacer;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.RecvDevice;
import com.integ.tasker.devices.SendDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.StringUtils;
import java.util.Json;

public class DeviceSendMethod
extends Action {
    public DeviceSendMethod(Task parentTask, Json json) {
        super(parentTask, json);
        String deviceGuid = this._paramsJson.getString("DeviceGUID");
        DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
        if (null == device) {
            throw new RuntimeException("No device found for " + deviceGuid);
        }
        String message = this._paramsJson.getString("Message");
        Json deviceActionJson = new Json();
        deviceActionJson.put("type", (Object)"DeviceSend");
        deviceActionJson.put("name", (Object)device.Name);
        deviceActionJson.put("message", (Object)message);
        this._parentTask.addDeviceActionJson(deviceActionJson);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        block13: {
            try {
                String deviceGuid = this._paramsJson.getString("DeviceGUID");
                String message = this._paramsJson.getString("Message");
                message = TextReplacer.replace(message, taskRuntime.Scope);
                byte[] dataBytes = StringUtils.getEscapedBytes(message);
                try {
                    if (null == deviceGuid || "".equals(deviceGuid)) {
                        throw new RuntimeException("No device was selected for this Device Send");
                    }
                    DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
                    if (null == device) {
                        throw new RuntimeException("No device found for " + deviceGuid);
                    }
                    try {
                        SendDevice sendDevice = (SendDevice)((Object)device);
                        sendDevice.send(dataBytes);
                        if (!this._paramsJson.containsKey("WaitForResponse")) break block13;
                        boolean waitForResponse = this._paramsJson.getBoolean("WaitForResponse");
                        System.out.println("waitForResponse = " + waitForResponse);
                        if (!waitForResponse) break block13;
                        try {
                            RecvDevice recvDevice = (RecvDevice)((Object)device);
                            byte[] responseBytes = recvDevice.receive();
                            String variableName = this._paramsJson.getString("VariableName");
                            String variableType = this._paramsJson.getString("VariableType");
                            if ("String".equalsIgnoreCase(variableType)) {
                                taskRuntime.Scope.setVariable(variableName, new String(responseBytes));
                            } else if ("Bytes".equalsIgnoreCase(variableType)) {
                                taskRuntime.Scope.setVariable(variableName, responseBytes);
                            }
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(String.format("Error receiving form %s - %s", device.toString(), ex.getMessage()));
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(String.format("Error sending %s to %s - %s", message, device.toString(), ex.getMessage()));
                    }
                }
                catch (Exception ex) {
                    AppLog.warn(ex);
                    new ErrorMessage(ex.getMessage()).postMessage();
                }
            }
            catch (Exception ex) {
                throw new Exception("Error executing Device Send").initCause(ex);
            }
        }
    }

    public String toString() {
        String message = this._paramsJson.getString("Message");
        return String.format("%s", message);
    }
}

