/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.ServerDevice;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.tcp.TcpServer;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import java.io.IOException;
import java.util.Json;

public class TCPServerDevice
extends ServerDevice
implements TcpServerListener {
    private int _port;
    private TcpServer _tcpServer = null;

    public TCPServerDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._port = paramsJson.getInt("Port");
            LOG.info(String.format("TCP Server Device: port: %d", this._port));
            this._tcpServer = new TcpServer("TCP Server", this._port);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public void setListener(TcpServerListener listener) {
        this._tcpServer.setTcpServerListener(listener);
    }

    @Override
    public void start() {
        LOG.info("starting " + this.Name);
        this._tcpServer.start();
    }

    @Override
    public void stop() {
        try {
            LOG.info("stopping " + this.Name);
            this._tcpServer.stop();
        }
        catch (IOException ex) {
            LOG.error("error stopping tcp server", ex);
        }
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        LOG.info(String.format("%s has connected to the TCP Server", evt.getSocket().toString()));
    }

    public String getIpAddress() {
        return "127.0.0.1";
    }

    public int getPort() {
        return this._port;
    }

    public void close() throws Exception {
    }
}

