/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.tasker.AssemblyInfo;
import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.ScheduleCollection;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.AssemblyInfoBase;
import com.integpg.janoslib.text.QuickDateFormat;
import java.util.ArrayList;

public class ScheduleMonitor
implements Runnable {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM-dd-yy HH:mm:ss");
    private static final Logger LOG;
    private static final ScheduleMonitor INSTANCE;
    private static Thread Thread;
    private static int TARGET_INTERVAL;
    private long _lastCheck = Long.MAX_VALUE;
    private long _now;

    public static void start() {
        if (null == Thread) {
            Thread = new Thread(INSTANCE);
            Thread.setName(ScheduleMonitor.class.getName());
            Thread.start();
        }
    }

    @Override
    public void run() {
        LOG.info("Schedule Monitor Starting...");
        long maxElapsed = 0L;
        while (true) {
            try {
                while (true) {
                    this._now = System.currentTimeMillis();
                    this.checkSchedules();
                    this._lastCheck = this._now;
                    long elapsed = System.currentTimeMillis() - this._now;
                    long sleepTime = (long)TARGET_INTERVAL - elapsed;
                    maxElapsed = elapsed > maxElapsed ? elapsed : (maxElapsed -= 100L);
                    if ((long)(TARGET_INTERVAL / 2) > sleepTime) {
                        sleepTime = 250L;
                        TARGET_INTERVAL = (int)(elapsed * 2L);
                        if (TARGET_INTERVAL > 5000) {
                            TARGET_INTERVAL = 5000;
                        }
                    } else {
                        TARGET_INTERVAL -= 10;
                    }
                    java.lang.Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void checkSchedules() {
        ArrayList<Schedule> schedules = ScheduleCollection.getSchedules();
        for (int i = 0; i < schedules.size(); ++i) {
            Schedule schedule = schedules.get(i);
            if (!schedule.isEnabled() || schedule.isUnloaded()) continue;
            ArrayList<ScheduleRuleBase> scheduleRules = schedule.getScheduleRules();
            for (ScheduleRuleBase scheduleRule : scheduleRules) {
                long nextExecutionTime;
                if (null == scheduleRule || this._lastCheck >= (nextExecutionTime = scheduleRule.getNextExecutionTime()) || nextExecutionTime > this._now) continue;
                schedule.execute();
                scheduleRule.updateNextExecutionTime();
            }
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        AssemblyInfo.getInstance();
        LOG = Logger.getLogger(stringBuilder.append(AssemblyInfoBase.getName()).append("_schedules.log").toString());
        INSTANCE = new ScheduleMonitor();
        Thread = null;
        TARGET_INTERVAL = 1000;
    }
}

