function parseDinControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'SoftInvert':
            return new DinSoftInvert();

        case 'SetCounter':
            return new DinSetCounter();

        case 'ResetUsageMeter':
            return new DinResetUsageMeter();

        case 'ClearLatch':
            return new DinClearLatch();

        case 'DinSetState':
            return new DinSetState();

        case 'DinSoftPulse':
            return new DinSoftPulse();

        default:
            throw new Error('Unknown DIN Action Method: ' + JSON.stringify(json, null, 2));
    }
}



class DinControl extends Action {
    constructor() {
        super();
        this.Type = 'DinControl';
        this.Method = 'void';
        this.Params = {};
    }
}


class DinResetUsageMeter extends DinControl {
    constructor(channel) {
        super();
        this.Method = 'ResetUsageMeter';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Reset Usage Meter for Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />';
        return template;
    }
}


class DinSetCounter extends DinControl {
    constructor(channel, value) {
        super();
        this.Method = 'SetCounter';
        this.Params.Channel = channel || 1;
        this.Params.Value = value || 0;
    }

    editTemplate() {
        var template = 'Set Counter for Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />' +
            ' to <input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Value"' +
            ' data-toggle="tooltip" title="Integer Value" style="width: 75px;" required />';
        return template;
    }
}


class DinSoftInvert extends DinControl {
    constructor(channel, inverted) {
        super();
        this.Method = 'SoftInvert';
        this.Params.Channel = channel || 1;
        this.Params.Inverted = inverted || true;
    }

    editTemplate() {
        var template = 'Soft Invert Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />' +
            ' Inverted <input type="checkbox" style="margin-left: 8px;" ng-model="action.Params.Inverted"' +
            ' data-toggle="tooltip" title="The state of the Inversion registry key" style="width: 75px;" />';
        return template;
    }
}


class DinClearLatch extends DinControl {
    constructor(channel, inverted) {
        super();
        this.Method = 'ClearLatch';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Clear Latch for Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />';
        return template;
    }
}


class DinSetState extends DinControl {
    constructor() {
        super();
        this.Method = 'DinSetState';
    }

    editTemplate() {
        var template = 'Set Input <input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />' +
            ' to <select ng-model="action.Params.ConditioningState" class="form-control">' +
            '   <option value="" default>Normal</option>' +
            '   <option value="1">Invert</option>' +
            '   <option value="2">Off</option>' +
            '   <option value="3">On</option>' +
            ' </select>';
        return template;
    }
}


class DinSoftPulse extends DinControl {
    constructor() {
        super();
        this.Method = 'DinSoftPulse';
    }

    editTemplate() {
        var template = 'Soft Pulse Input <input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />' +
            ' for <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Duration"' +
            ' data-toggle="tooltip" title="Length of pulse in seconds.  Seconds can be represented with a decimal point and do not need to be whole seconds." style="width: 100px;" /> seconds'; //\r\n' +
        return template;
    }
}
