/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.resettypes;

import com.integ.tasker.triggers.Reset;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.Json;

public class DelayedReset
extends Reset {
    private final long _delayTimeMillis;

    public DelayedReset(int millis) {
        this._delayTimeMillis = millis;
    }

    public DelayedReset(Json resetJson) {
        Json paramsJson = (Json)resetJson.get("Params");
        double seconds = paramsJson.getDouble("DelayTime");
        this._delayTimeMillis = (long)(seconds * 1000.0);
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
    }

    @Override
    public void checkForReset() throws Throwable {
        if (!this._trigger.isTriggered()) {
            return;
        }
        long expireTime = this._trigger.getLastTriggerTime() + this._delayTimeMillis;
        if (System.currentTimeMillis() >= expireTime) {
            this.resetTrigger();
        }
    }
}

