/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.EthernetDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.logging.AppLog;
import java.util.Json;

public class TcpCloseMethod
extends Action {
    public TcpCloseMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            String deviceGuid = this._paramsJson.getString("DeviceGUID");
            try {
                if (null == deviceGuid || "".equals(deviceGuid)) {
                    throw new RuntimeException("No device was selected for this TCP Close");
                }
                DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
                if (null == device) {
                    throw new RuntimeException("No device found for " + deviceGuid);
                }
                if (!(device instanceof EthernetDevice)) {
                    throw new RuntimeException("Device found for " + deviceGuid + " is not an Ethernet Device");
                }
                EthernetDevice ethernetDevice = (EthernetDevice)device;
                try {
                    ethernetDevice.close();
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Error closing %s:%d - %s", ethernetDevice.getIpAddress(), ethernetDevice.getPort(), ex.getMessage()));
                }
            }
            catch (Exception ex) {
                AppLog.warn(ex);
                new ErrorMessage(ex.getMessage()).postMessage();
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing TCP Close").initCause(ex);
        }
    }
}

