/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.TextReplacer;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.SerialPort;
import com.integpg.janoslib.utils.StringUtils;
import java.util.Json;

public class SerialSendMethod
extends Action {
    private static final Object LOCK = new Object();
    private static boolean PORT_OPEN = false;
    private static SerialPort SERIAL_PORT = null;
    private final String _serialPortString;

    public SerialSendMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._serialPortString = this._paramsJson.getString("SerialPort");
        String message = this._paramsJson.getString("Message");
        Json deviceActionJson = new Json();
        deviceActionJson.put("type", (Object)"SerialSend");
        deviceActionJson.put("name", (Object)this._serialPortString);
        deviceActionJson.put("message", (Object)message);
        this._parentTask.addDeviceActionJson(deviceActionJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            Object object = LOCK;
            synchronized (object) {
                if (!PORT_OPEN) {
                    PORT_OPEN = true;
                    if ("AUX".equalsIgnoreCase(this._serialPortString)) {
                        SERIAL_PORT = new AUXSerialPort();
                    } else if ("COM".equalsIgnoreCase(this._serialPortString)) {
                        SERIAL_PORT = new COMSerialPort();
                    }
                    SERIAL_PORT.open();
                }
                String message = this._paramsJson.getString("Message");
                message = TextReplacer.replace(message, taskRuntime.Scope);
                byte[] dataBytes = StringUtils.getEscapedBytes(message);
                SERIAL_PORT.getOutputStream().write(dataBytes);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing Serial Send").initCause(ex);
        }
    }

    public String toString() {
        String message = this._paramsJson.getString("Message");
        return String.format("%s", message);
    }
}

